package zio.aws.amplifybackend.model
import zio.aws.amplifybackend.model.primitives.__string
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateBackendRequest(
    appId: __string,
    appName: __string,
    backendEnvironmentName: __string,
    resourceConfig: Optional[zio.aws.amplifybackend.model.ResourceConfig] =
      Optional.Absent,
    resourceName: Optional[__string] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.amplifybackend.model.CreateBackendRequest = {
    import CreateBackendRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplifybackend.model.CreateBackendRequest
      .builder()
      .appId(appId: java.lang.String)
      .appName(appName: java.lang.String)
      .backendEnvironmentName(backendEnvironmentName: java.lang.String)
      .optionallyWith(resourceConfig.map(value => value.buildAwsValue()))(
        _.resourceConfig
      )
      .optionallyWith(resourceName.map(value => value: java.lang.String))(
        _.resourceName
      )
      .build()
  }
  def asReadOnly: zio.aws.amplifybackend.model.CreateBackendRequest.ReadOnly =
    zio.aws.amplifybackend.model.CreateBackendRequest.wrap(buildAwsValue())
}
object CreateBackendRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.amplifybackend.model.CreateBackendRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.amplifybackend.model.CreateBackendRequest =
      zio.aws.amplifybackend.model.CreateBackendRequest(
        appId,
        appName,
        backendEnvironmentName,
        resourceConfig.map(value => value.asEditable),
        resourceName.map(value => value)
      )
    def appId: __string
    def appName: __string
    def backendEnvironmentName: __string
    def resourceConfig
        : Optional[zio.aws.amplifybackend.model.ResourceConfig.ReadOnly]
    def resourceName: Optional[__string]
    def getAppId: ZIO[Any, Nothing, __string] = ZIO.succeed(appId)
    def getAppName: ZIO[Any, Nothing, __string] = ZIO.succeed(appName)
    def getBackendEnvironmentName: ZIO[Any, Nothing, __string] =
      ZIO.succeed(backendEnvironmentName)
    def getResourceConfig: ZIO[
      Any,
      AwsError,
      zio.aws.amplifybackend.model.ResourceConfig.ReadOnly
    ] = AwsError.unwrapOptionField("resourceConfig", resourceConfig)
    def getResourceName: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("resourceName", resourceName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplifybackend.model.CreateBackendRequest
  ) extends zio.aws.amplifybackend.model.CreateBackendRequest.ReadOnly {
    override val appId: __string = impl.appId(): __string
    override val appName: __string = impl.appName(): __string
    override val backendEnvironmentName: __string =
      impl.backendEnvironmentName(): __string
    override val resourceConfig
        : Optional[zio.aws.amplifybackend.model.ResourceConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceConfig())
        .map(value => zio.aws.amplifybackend.model.ResourceConfig.wrap(value))
    override val resourceName: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.resourceName())
      .map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplifybackend.model.CreateBackendRequest
  ): zio.aws.amplifybackend.model.CreateBackendRequest.ReadOnly = new Wrapper(
    impl
  )
}
