package zio.aws.amplifybackend.model
import zio.aws.amplifybackend.model.primitives.__string
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class BackendAPIResourceConfig(
    additionalAuthTypes: Optional[
      Iterable[zio.aws.amplifybackend.model.BackendAPIAuthType]
    ] = Optional.Absent,
    apiName: Optional[__string] = Optional.Absent,
    conflictResolution: Optional[
      zio.aws.amplifybackend.model.BackendAPIConflictResolution
    ] = Optional.Absent,
    defaultAuthType: Optional[zio.aws.amplifybackend.model.BackendAPIAuthType] =
      Optional.Absent,
    service: Optional[__string] = Optional.Absent,
    transformSchema: Optional[__string] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.amplifybackend.model.BackendAPIResourceConfig = {
    import BackendAPIResourceConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplifybackend.model.BackendAPIResourceConfig
      .builder()
      .optionallyWith(
        additionalAuthTypes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.additionalAuthTypes)
      .optionallyWith(apiName.map(value => value: java.lang.String))(_.apiName)
      .optionallyWith(conflictResolution.map(value => value.buildAwsValue()))(
        _.conflictResolution
      )
      .optionallyWith(defaultAuthType.map(value => value.buildAwsValue()))(
        _.defaultAuthType
      )
      .optionallyWith(service.map(value => value: java.lang.String))(_.service)
      .optionallyWith(transformSchema.map(value => value: java.lang.String))(
        _.transformSchema
      )
      .build()
  }
  def asReadOnly
      : zio.aws.amplifybackend.model.BackendAPIResourceConfig.ReadOnly =
    zio.aws.amplifybackend.model.BackendAPIResourceConfig.wrap(buildAwsValue())
}
object BackendAPIResourceConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.amplifybackend.model.BackendAPIResourceConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.amplifybackend.model.BackendAPIResourceConfig =
      zio.aws.amplifybackend.model.BackendAPIResourceConfig(
        additionalAuthTypes.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        apiName.map(value => value),
        conflictResolution.map(value => value.asEditable),
        defaultAuthType.map(value => value.asEditable),
        service.map(value => value),
        transformSchema.map(value => value)
      )
    def additionalAuthTypes: Optional[
      List[zio.aws.amplifybackend.model.BackendAPIAuthType.ReadOnly]
    ]
    def apiName: Optional[__string]
    def conflictResolution: Optional[
      zio.aws.amplifybackend.model.BackendAPIConflictResolution.ReadOnly
    ]
    def defaultAuthType
        : Optional[zio.aws.amplifybackend.model.BackendAPIAuthType.ReadOnly]
    def service: Optional[__string]
    def transformSchema: Optional[__string]
    def getAdditionalAuthTypes: ZIO[Any, AwsError, List[
      zio.aws.amplifybackend.model.BackendAPIAuthType.ReadOnly
    ]] = AwsError.unwrapOptionField("additionalAuthTypes", additionalAuthTypes)
    def getApiName: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("apiName", apiName)
    def getConflictResolution: ZIO[
      Any,
      AwsError,
      zio.aws.amplifybackend.model.BackendAPIConflictResolution.ReadOnly
    ] = AwsError.unwrapOptionField("conflictResolution", conflictResolution)
    def getDefaultAuthType: ZIO[
      Any,
      AwsError,
      zio.aws.amplifybackend.model.BackendAPIAuthType.ReadOnly
    ] = AwsError.unwrapOptionField("defaultAuthType", defaultAuthType)
    def getService: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("service", service)
    def getTransformSchema: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("transformSchema", transformSchema)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplifybackend.model.BackendAPIResourceConfig
  ) extends zio.aws.amplifybackend.model.BackendAPIResourceConfig.ReadOnly {
    override val additionalAuthTypes: Optional[
      List[zio.aws.amplifybackend.model.BackendAPIAuthType.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.additionalAuthTypes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.amplifybackend.model.BackendAPIAuthType.wrap(item)
        }.toList
      )
    override val apiName: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.apiName())
      .map(value => value: __string)
    override val conflictResolution: Optional[
      zio.aws.amplifybackend.model.BackendAPIConflictResolution.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.conflictResolution())
      .map(value =>
        zio.aws.amplifybackend.model.BackendAPIConflictResolution.wrap(value)
      )
    override val defaultAuthType
        : Optional[zio.aws.amplifybackend.model.BackendAPIAuthType.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.defaultAuthType())
        .map(value =>
          zio.aws.amplifybackend.model.BackendAPIAuthType.wrap(value)
        )
    override val service: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.service())
      .map(value => value: __string)
    override val transformSchema: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.transformSchema())
      .map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplifybackend.model.BackendAPIResourceConfig
  ): zio.aws.amplifybackend.model.BackendAPIResourceConfig.ReadOnly =
    new Wrapper(impl)
}
