package zio.aws.amplifybackend.model
import zio.aws.amplifybackend.model.primitives.__string
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetBackendRequest(
    appId: __string,
    backendEnvironmentName: Optional[__string] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.amplifybackend.model.GetBackendRequest = {
    import GetBackendRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplifybackend.model.GetBackendRequest
      .builder()
      .appId(appId: java.lang.String)
      .optionallyWith(
        backendEnvironmentName.map(value => value: java.lang.String)
      )(_.backendEnvironmentName)
      .build()
  }
  def asReadOnly: zio.aws.amplifybackend.model.GetBackendRequest.ReadOnly =
    zio.aws.amplifybackend.model.GetBackendRequest.wrap(buildAwsValue())
}
object GetBackendRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.amplifybackend.model.GetBackendRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.amplifybackend.model.GetBackendRequest =
      zio.aws.amplifybackend.model
        .GetBackendRequest(appId, backendEnvironmentName.map(value => value))
    def appId: __string
    def backendEnvironmentName: Optional[__string]
    def getAppId: ZIO[Any, Nothing, __string] = ZIO.succeed(appId)
    def getBackendEnvironmentName: ZIO[Any, AwsError, __string] = AwsError
      .unwrapOptionField("backendEnvironmentName", backendEnvironmentName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplifybackend.model.GetBackendRequest
  ) extends zio.aws.amplifybackend.model.GetBackendRequest.ReadOnly {
    override val appId: __string = impl.appId(): __string
    override val backendEnvironmentName: Optional[__string] =
      zio.aws.core.internal
        .optionalFromNullable(impl.backendEnvironmentName())
        .map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplifybackend.model.GetBackendRequest
  ): zio.aws.amplifybackend.model.GetBackendRequest.ReadOnly = new Wrapper(impl)
}
