package zio.aws.amplifybackend.model
import zio.aws.amplifybackend.model.primitives.__string
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListS3BucketsRequest(
    nextToken: Optional[__string] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.amplifybackend.model.ListS3BucketsRequest = {
    import ListS3BucketsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplifybackend.model.ListS3BucketsRequest
      .builder()
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.amplifybackend.model.ListS3BucketsRequest.ReadOnly =
    zio.aws.amplifybackend.model.ListS3BucketsRequest.wrap(buildAwsValue())
}
object ListS3BucketsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.amplifybackend.model.ListS3BucketsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.amplifybackend.model.ListS3BucketsRequest =
      zio.aws.amplifybackend.model
        .ListS3BucketsRequest(nextToken.map(value => value))
    def nextToken: Optional[__string]
    def getNextToken: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplifybackend.model.ListS3BucketsRequest
  ) extends zio.aws.amplifybackend.model.ListS3BucketsRequest.ReadOnly {
    override val nextToken: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplifybackend.model.ListS3BucketsRequest
  ): zio.aws.amplifybackend.model.ListS3BucketsRequest.ReadOnly = new Wrapper(
    impl
  )
}
