package zio.aws.amplifybackend.model
import zio.aws.amplifybackend.model.primitives.__string
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UpdateBackendAuthOAuthConfig(
    domainPrefix: Optional[__string] = Optional.Absent,
    oAuthGrantType: Optional[zio.aws.amplifybackend.model.OAuthGrantType] =
      Optional.Absent,
    oAuthScopes: Optional[
      Iterable[zio.aws.amplifybackend.model.OAuthScopesElement]
    ] = Optional.Absent,
    redirectSignInURIs: Optional[Iterable[__string]] = Optional.Absent,
    redirectSignOutURIs: Optional[Iterable[__string]] = Optional.Absent,
    socialProviderSettings: Optional[
      zio.aws.amplifybackend.model.SocialProviderSettings
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.amplifybackend.model.UpdateBackendAuthOAuthConfig = {
    import UpdateBackendAuthOAuthConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplifybackend.model.UpdateBackendAuthOAuthConfig
      .builder()
      .optionallyWith(domainPrefix.map(value => value: java.lang.String))(
        _.domainPrefix
      )
      .optionallyWith(oAuthGrantType.map(value => value.unwrap))(
        _.oAuthGrantType
      )
      .optionallyWith(
        oAuthScopes.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.oAuthScopesWithStrings)
      .optionallyWith(
        redirectSignInURIs.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.redirectSignInURIs)
      .optionallyWith(
        redirectSignOutURIs.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.redirectSignOutURIs)
      .optionallyWith(
        socialProviderSettings.map(value => value.buildAwsValue())
      )(_.socialProviderSettings)
      .build()
  }
  def asReadOnly
      : zio.aws.amplifybackend.model.UpdateBackendAuthOAuthConfig.ReadOnly =
    zio.aws.amplifybackend.model.UpdateBackendAuthOAuthConfig
      .wrap(buildAwsValue())
}
object UpdateBackendAuthOAuthConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.amplifybackend.model.UpdateBackendAuthOAuthConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.amplifybackend.model.UpdateBackendAuthOAuthConfig =
      zio.aws.amplifybackend.model.UpdateBackendAuthOAuthConfig(
        domainPrefix.map(value => value),
        oAuthGrantType.map(value => value),
        oAuthScopes.map(value => value),
        redirectSignInURIs.map(value => value),
        redirectSignOutURIs.map(value => value),
        socialProviderSettings.map(value => value.asEditable)
      )
    def domainPrefix: Optional[__string]
    def oAuthGrantType: Optional[zio.aws.amplifybackend.model.OAuthGrantType]
    def oAuthScopes
        : Optional[List[zio.aws.amplifybackend.model.OAuthScopesElement]]
    def redirectSignInURIs: Optional[List[__string]]
    def redirectSignOutURIs: Optional[List[__string]]
    def socialProviderSettings
        : Optional[zio.aws.amplifybackend.model.SocialProviderSettings.ReadOnly]
    def getDomainPrefix: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("domainPrefix", domainPrefix)
    def getOAuthGrantType
        : ZIO[Any, AwsError, zio.aws.amplifybackend.model.OAuthGrantType] =
      AwsError.unwrapOptionField("oAuthGrantType", oAuthGrantType)
    def getOAuthScopes: ZIO[Any, AwsError, List[
      zio.aws.amplifybackend.model.OAuthScopesElement
    ]] = AwsError.unwrapOptionField("oAuthScopes", oAuthScopes)
    def getRedirectSignInURIs: ZIO[Any, AwsError, List[__string]] =
      AwsError.unwrapOptionField("redirectSignInURIs", redirectSignInURIs)
    def getRedirectSignOutURIs: ZIO[Any, AwsError, List[__string]] =
      AwsError.unwrapOptionField("redirectSignOutURIs", redirectSignOutURIs)
    def getSocialProviderSettings: ZIO[
      Any,
      AwsError,
      zio.aws.amplifybackend.model.SocialProviderSettings.ReadOnly
    ] = AwsError.unwrapOptionField(
      "socialProviderSettings",
      socialProviderSettings
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplifybackend.model.UpdateBackendAuthOAuthConfig
  ) extends zio.aws.amplifybackend.model.UpdateBackendAuthOAuthConfig.ReadOnly {
    override val domainPrefix: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.domainPrefix())
      .map(value => value: __string)
    override val oAuthGrantType
        : Optional[zio.aws.amplifybackend.model.OAuthGrantType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.oAuthGrantType())
        .map(value => zio.aws.amplifybackend.model.OAuthGrantType.wrap(value))
    override val oAuthScopes
        : Optional[List[zio.aws.amplifybackend.model.OAuthScopesElement]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.oAuthScopes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.amplifybackend.model.OAuthScopesElement.wrap(item)
          }.toList
        )
    override val redirectSignInURIs: Optional[List[__string]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.redirectSignInURIs())
        .map(value =>
          value.asScala.map { item =>
            item: __string
          }.toList
        )
    override val redirectSignOutURIs: Optional[List[__string]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.redirectSignOutURIs())
        .map(value =>
          value.asScala.map { item =>
            item: __string
          }.toList
        )
    override val socialProviderSettings: Optional[
      zio.aws.amplifybackend.model.SocialProviderSettings.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.socialProviderSettings())
      .map(value =>
        zio.aws.amplifybackend.model.SocialProviderSettings.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplifybackend.model.UpdateBackendAuthOAuthConfig
  ): zio.aws.amplifybackend.model.UpdateBackendAuthOAuthConfig.ReadOnly =
    new Wrapper(impl)
}
