package zio.aws.amplifybackend.model
import zio.aws.amplifybackend.model.primitives.__string
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class EmailSettings(
    emailMessage: Optional[__string] = Optional.Absent,
    emailSubject: Optional[__string] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.amplifybackend.model.EmailSettings = {
    import EmailSettings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplifybackend.model.EmailSettings
      .builder()
      .optionallyWith(emailMessage.map(value => value: java.lang.String))(
        _.emailMessage
      )
      .optionallyWith(emailSubject.map(value => value: java.lang.String))(
        _.emailSubject
      )
      .build()
  }
  def asReadOnly: zio.aws.amplifybackend.model.EmailSettings.ReadOnly =
    zio.aws.amplifybackend.model.EmailSettings.wrap(buildAwsValue())
}
object EmailSettings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.amplifybackend.model.EmailSettings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.amplifybackend.model.EmailSettings =
      zio.aws.amplifybackend.model.EmailSettings(
        emailMessage.map(value => value),
        emailSubject.map(value => value)
      )
    def emailMessage: Optional[__string]
    def emailSubject: Optional[__string]
    def getEmailMessage: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("emailMessage", emailMessage)
    def getEmailSubject: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("emailSubject", emailSubject)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplifybackend.model.EmailSettings
  ) extends zio.aws.amplifybackend.model.EmailSettings.ReadOnly {
    override val emailMessage: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.emailMessage())
      .map(value => value: __string)
    override val emailSubject: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.emailSubject())
      .map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplifybackend.model.EmailSettings
  ): zio.aws.amplifybackend.model.EmailSettings.ReadOnly = new Wrapper(impl)
}
