package zio.aws.amplifybackend.model
import zio.aws.amplifybackend.model.primitives.__string
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class BackendAuthSocialProviderConfig(
    clientId: Optional[__string] = Optional.Absent,
    clientSecret: Optional[__string] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.amplifybackend.model.BackendAuthSocialProviderConfig = {
    import BackendAuthSocialProviderConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplifybackend.model.BackendAuthSocialProviderConfig
      .builder()
      .optionallyWith(clientId.map(value => value: java.lang.String))(
        _.clientId
      )
      .optionallyWith(clientSecret.map(value => value: java.lang.String))(
        _.clientSecret
      )
      .build()
  }
  def asReadOnly
      : zio.aws.amplifybackend.model.BackendAuthSocialProviderConfig.ReadOnly =
    zio.aws.amplifybackend.model.BackendAuthSocialProviderConfig
      .wrap(buildAwsValue())
}
object BackendAuthSocialProviderConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.amplifybackend.model.BackendAuthSocialProviderConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.amplifybackend.model.BackendAuthSocialProviderConfig =
      zio.aws.amplifybackend.model.BackendAuthSocialProviderConfig(
        clientId.map(value => value),
        clientSecret.map(value => value)
      )
    def clientId: Optional[__string]
    def clientSecret: Optional[__string]
    def getClientId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("clientId", clientId)
    def getClientSecret: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("clientSecret", clientSecret)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplifybackend.model.BackendAuthSocialProviderConfig
  ) extends zio.aws.amplifybackend.model.BackendAuthSocialProviderConfig.ReadOnly {
    override val clientId: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.clientId())
      .map(value => value: __string)
    override val clientSecret: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.clientSecret())
      .map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplifybackend.model.BackendAuthSocialProviderConfig
  ): zio.aws.amplifybackend.model.BackendAuthSocialProviderConfig.ReadOnly =
    new Wrapper(impl)
}
