package zio.aws.amplifybackend.model
import zio.aws.amplifybackend.model.primitives.__string
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class UpdateBackendAuthResponse(
    appId: Option[__string] = None,
    backendEnvironmentName: Option[__string] = None,
    error: Option[__string] = None,
    jobId: Option[__string] = None,
    operation: Option[__string] = None,
    status: Option[__string] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.amplifybackend.model.UpdateBackendAuthResponse = {
    import UpdateBackendAuthResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplifybackend.model.UpdateBackendAuthResponse
      .builder()
      .optionallyWith(appId.map(value => value: java.lang.String))(_.appId)
      .optionallyWith(
        backendEnvironmentName.map(value => value: java.lang.String)
      )(_.backendEnvironmentName)
      .optionallyWith(error.map(value => value: java.lang.String))(_.error)
      .optionallyWith(jobId.map(value => value: java.lang.String))(_.jobId)
      .optionallyWith(operation.map(value => value: java.lang.String))(
        _.operation
      )
      .optionallyWith(status.map(value => value: java.lang.String))(_.status)
      .build()
  }
  def asReadOnly
      : zio.aws.amplifybackend.model.UpdateBackendAuthResponse.ReadOnly =
    zio.aws.amplifybackend.model.UpdateBackendAuthResponse.wrap(buildAwsValue())
}
object UpdateBackendAuthResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.amplifybackend.model.UpdateBackendAuthResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.amplifybackend.model.UpdateBackendAuthResponse =
      zio.aws.amplifybackend.model.UpdateBackendAuthResponse(
        appId.map(value => value),
        backendEnvironmentName.map(value => value),
        error.map(value => value),
        jobId.map(value => value),
        operation.map(value => value),
        status.map(value => value)
      )
    def appId: Option[__string]
    def backendEnvironmentName: Option[__string]
    def error: Option[__string]
    def jobId: Option[__string]
    def operation: Option[__string]
    def status: Option[__string]
    def getAppId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("appId", appId)
    def getBackendEnvironmentName: ZIO[Any, AwsError, __string] = AwsError
      .unwrapOptionField("backendEnvironmentName", backendEnvironmentName)
    def getError: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("error", error)
    def getJobId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("jobId", jobId)
    def getOperation: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("operation", operation)
    def getStatus: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplifybackend.model.UpdateBackendAuthResponse
  ) extends zio.aws.amplifybackend.model.UpdateBackendAuthResponse.ReadOnly {
    override val appId: Option[__string] =
      scala.Option(impl.appId()).map(value => value: __string)
    override val backendEnvironmentName: Option[__string] =
      scala.Option(impl.backendEnvironmentName()).map(value => value: __string)
    override val error: Option[__string] =
      scala.Option(impl.error()).map(value => value: __string)
    override val jobId: Option[__string] =
      scala.Option(impl.jobId()).map(value => value: __string)
    override val operation: Option[__string] =
      scala.Option(impl.operation()).map(value => value: __string)
    override val status: Option[__string] =
      scala.Option(impl.status()).map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplifybackend.model.UpdateBackendAuthResponse
  ): zio.aws.amplifybackend.model.UpdateBackendAuthResponse.ReadOnly =
    new Wrapper(impl)
}
