package zio.aws.amplifybackend.model
import scala.jdk.CollectionConverters.*
sealed trait ResolutionStrategy {
  def unwrap
      : software.amazon.awssdk.services.amplifybackend.model.ResolutionStrategy
}
object ResolutionStrategy {
  def wrap(
      value: software.amazon.awssdk.services.amplifybackend.model.ResolutionStrategy
  ): zio.aws.amplifybackend.model.ResolutionStrategy = value match {
    case software.amazon.awssdk.services.amplifybackend.model.ResolutionStrategy.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.amplifybackend.model.ResolutionStrategy.OPTIMISTIC_CONCURRENCY =>
      val r = OPTIMISTIC_CONCURRENCY
      r
    case software.amazon.awssdk.services.amplifybackend.model.ResolutionStrategy.LAMBDA =>
      val r = LAMBDA
      r
    case software.amazon.awssdk.services.amplifybackend.model.ResolutionStrategy.AUTOMERGE =>
      val r = AUTOMERGE
      r
    case software.amazon.awssdk.services.amplifybackend.model.ResolutionStrategy.NONE =>
      val r = NONE
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.amplifybackend.model.ResolutionStrategy {
    override def unwrap
        : software.amazon.awssdk.services.amplifybackend.model.ResolutionStrategy =
      software.amazon.awssdk.services.amplifybackend.model.ResolutionStrategy.UNKNOWN_TO_SDK_VERSION
  }
  case object OPTIMISTIC_CONCURRENCY
      extends zio.aws.amplifybackend.model.ResolutionStrategy {
    override def unwrap
        : software.amazon.awssdk.services.amplifybackend.model.ResolutionStrategy =
      software.amazon.awssdk.services.amplifybackend.model.ResolutionStrategy.OPTIMISTIC_CONCURRENCY
  }
  case object LAMBDA extends zio.aws.amplifybackend.model.ResolutionStrategy {
    override def unwrap
        : software.amazon.awssdk.services.amplifybackend.model.ResolutionStrategy =
      software.amazon.awssdk.services.amplifybackend.model.ResolutionStrategy.LAMBDA
  }
  case object AUTOMERGE
      extends zio.aws.amplifybackend.model.ResolutionStrategy {
    override def unwrap
        : software.amazon.awssdk.services.amplifybackend.model.ResolutionStrategy =
      software.amazon.awssdk.services.amplifybackend.model.ResolutionStrategy.AUTOMERGE
  }
  case object NONE extends zio.aws.amplifybackend.model.ResolutionStrategy {
    override def unwrap
        : software.amazon.awssdk.services.amplifybackend.model.ResolutionStrategy =
      software.amazon.awssdk.services.amplifybackend.model.ResolutionStrategy.NONE
  }
}
