package zio.aws.amplifybackend.model
import scala.jdk.CollectionConverters.*
sealed trait OAuthGrantType {
  def unwrap
      : software.amazon.awssdk.services.amplifybackend.model.OAuthGrantType
}
object OAuthGrantType {
  def wrap(
      value: software.amazon.awssdk.services.amplifybackend.model.OAuthGrantType
  ): zio.aws.amplifybackend.model.OAuthGrantType = value match {
    case software.amazon.awssdk.services.amplifybackend.model.OAuthGrantType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.amplifybackend.model.OAuthGrantType.CODE =>
      val r = CODE
      r
    case software.amazon.awssdk.services.amplifybackend.model.OAuthGrantType.IMPLICIT =>
      val r = IMPLICIT
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.amplifybackend.model.OAuthGrantType {
    override def unwrap
        : software.amazon.awssdk.services.amplifybackend.model.OAuthGrantType =
      software.amazon.awssdk.services.amplifybackend.model.OAuthGrantType.UNKNOWN_TO_SDK_VERSION
  }
  case object CODE extends zio.aws.amplifybackend.model.OAuthGrantType {
    override def unwrap
        : software.amazon.awssdk.services.amplifybackend.model.OAuthGrantType =
      software.amazon.awssdk.services.amplifybackend.model.OAuthGrantType.CODE
  }
  case object IMPLICIT extends zio.aws.amplifybackend.model.OAuthGrantType {
    override def unwrap
        : software.amazon.awssdk.services.amplifybackend.model.OAuthGrantType =
      software.amazon.awssdk.services.amplifybackend.model.OAuthGrantType.IMPLICIT
  }
}
