package zio.aws.amplifybackend.model
import zio.aws.amplifybackend.model.primitives.__string
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class LoginAuthConfigReqObj(
    awsCognitoIdentityPoolId: Option[__string] = None,
    awsCognitoRegion: Option[__string] = None,
    awsUserPoolsId: Option[__string] = None,
    awsUserPoolsWebClientId: Option[__string] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.amplifybackend.model.LoginAuthConfigReqObj = {
    import LoginAuthConfigReqObj.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplifybackend.model.LoginAuthConfigReqObj
      .builder()
      .optionallyWith(
        awsCognitoIdentityPoolId.map(value => value: java.lang.String)
      )(_.awsCognitoIdentityPoolId)
      .optionallyWith(awsCognitoRegion.map(value => value: java.lang.String))(
        _.awsCognitoRegion
      )
      .optionallyWith(awsUserPoolsId.map(value => value: java.lang.String))(
        _.awsUserPoolsId
      )
      .optionallyWith(
        awsUserPoolsWebClientId.map(value => value: java.lang.String)
      )(_.awsUserPoolsWebClientId)
      .build()
  }
  def asReadOnly: zio.aws.amplifybackend.model.LoginAuthConfigReqObj.ReadOnly =
    zio.aws.amplifybackend.model.LoginAuthConfigReqObj.wrap(buildAwsValue())
}
object LoginAuthConfigReqObj {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.amplifybackend.model.LoginAuthConfigReqObj
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.amplifybackend.model.LoginAuthConfigReqObj =
      zio.aws.amplifybackend.model.LoginAuthConfigReqObj(
        awsCognitoIdentityPoolId.map(value => value),
        awsCognitoRegion.map(value => value),
        awsUserPoolsId.map(value => value),
        awsUserPoolsWebClientId.map(value => value)
      )
    def awsCognitoIdentityPoolId: Option[__string]
    def awsCognitoRegion: Option[__string]
    def awsUserPoolsId: Option[__string]
    def awsUserPoolsWebClientId: Option[__string]
    def getAwsCognitoIdentityPoolId: ZIO[Any, AwsError, __string] = AwsError
      .unwrapOptionField("awsCognitoIdentityPoolId", awsCognitoIdentityPoolId)
    def getAwsCognitoRegion: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("awsCognitoRegion", awsCognitoRegion)
    def getAwsUserPoolsId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("awsUserPoolsId", awsUserPoolsId)
    def getAwsUserPoolsWebClientId: ZIO[Any, AwsError, __string] = AwsError
      .unwrapOptionField("awsUserPoolsWebClientId", awsUserPoolsWebClientId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplifybackend.model.LoginAuthConfigReqObj
  ) extends zio.aws.amplifybackend.model.LoginAuthConfigReqObj.ReadOnly {
    override val awsCognitoIdentityPoolId: Option[__string] = scala
      .Option(impl.awsCognitoIdentityPoolId())
      .map(value => value: __string)
    override val awsCognitoRegion: Option[__string] =
      scala.Option(impl.awsCognitoRegion()).map(value => value: __string)
    override val awsUserPoolsId: Option[__string] =
      scala.Option(impl.awsUserPoolsId()).map(value => value: __string)
    override val awsUserPoolsWebClientId: Option[__string] =
      scala.Option(impl.awsUserPoolsWebClientId()).map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplifybackend.model.LoginAuthConfigReqObj
  ): zio.aws.amplifybackend.model.LoginAuthConfigReqObj.ReadOnly = new Wrapper(
    impl
  )
}
