package zio.aws.amplifybackend.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CreateBackendAuthMFAConfig(
    mfaMode: zio.aws.amplifybackend.model.MFAMode,
    settings: Option[zio.aws.amplifybackend.model.Settings] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.amplifybackend.model.CreateBackendAuthMFAConfig = {
    import CreateBackendAuthMFAConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplifybackend.model.CreateBackendAuthMFAConfig
      .builder()
      .mfaMode(mfaMode.unwrap)
      .optionallyWith(settings.map(value => value.buildAwsValue()))(_.settings)
      .build()
  }
  def asReadOnly
      : zio.aws.amplifybackend.model.CreateBackendAuthMFAConfig.ReadOnly =
    zio.aws.amplifybackend.model.CreateBackendAuthMFAConfig
      .wrap(buildAwsValue())
}
object CreateBackendAuthMFAConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.amplifybackend.model.CreateBackendAuthMFAConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.amplifybackend.model.CreateBackendAuthMFAConfig =
      zio.aws.amplifybackend.model.CreateBackendAuthMFAConfig(
        mfaMode,
        settings.map(value => value.asEditable)
      )
    def mfaMode: zio.aws.amplifybackend.model.MFAMode
    def settings: Option[zio.aws.amplifybackend.model.Settings.ReadOnly]
    def getMfaMode: ZIO[Any, Nothing, zio.aws.amplifybackend.model.MFAMode] =
      ZIO.succeed(mfaMode)
    def getSettings
        : ZIO[Any, AwsError, zio.aws.amplifybackend.model.Settings.ReadOnly] =
      AwsError.unwrapOptionField("settings", settings)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplifybackend.model.CreateBackendAuthMFAConfig
  ) extends zio.aws.amplifybackend.model.CreateBackendAuthMFAConfig.ReadOnly {
    override val mfaMode: zio.aws.amplifybackend.model.MFAMode =
      zio.aws.amplifybackend.model.MFAMode.wrap(impl.mfaMode())
    override val settings
        : Option[zio.aws.amplifybackend.model.Settings.ReadOnly] = scala
      .Option(impl.settings())
      .map(value => zio.aws.amplifybackend.model.Settings.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplifybackend.model.CreateBackendAuthMFAConfig
  ): zio.aws.amplifybackend.model.CreateBackendAuthMFAConfig.ReadOnly =
    new Wrapper(impl)
}
