package zio.aws.amplifybackend.model
import scala.jdk.CollectionConverters.*
sealed trait MfaTypesElement {
  def unwrap
      : software.amazon.awssdk.services.amplifybackend.model.MfaTypesElement
}
object MfaTypesElement {
  def wrap(
      value: software.amazon.awssdk.services.amplifybackend.model.MfaTypesElement
  ): zio.aws.amplifybackend.model.MfaTypesElement = value match {
    case software.amazon.awssdk.services.amplifybackend.model.MfaTypesElement.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.amplifybackend.model.MfaTypesElement.SMS =>
      val r = SMS
      r
    case software.amazon.awssdk.services.amplifybackend.model.MfaTypesElement.TOTP =>
      val r = TOTP
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.amplifybackend.model.MfaTypesElement {
    override def unwrap
        : software.amazon.awssdk.services.amplifybackend.model.MfaTypesElement =
      software.amazon.awssdk.services.amplifybackend.model.MfaTypesElement.UNKNOWN_TO_SDK_VERSION
  }
  case object SMS extends zio.aws.amplifybackend.model.MfaTypesElement {
    override def unwrap
        : software.amazon.awssdk.services.amplifybackend.model.MfaTypesElement =
      software.amazon.awssdk.services.amplifybackend.model.MfaTypesElement.SMS
  }
  case object TOTP extends zio.aws.amplifybackend.model.MfaTypesElement {
    override def unwrap
        : software.amazon.awssdk.services.amplifybackend.model.MfaTypesElement =
      software.amazon.awssdk.services.amplifybackend.model.MfaTypesElement.TOTP
  }
}
