package zio.aws.amplifybackend.model
import zio.aws.amplifybackend.model.primitives.__string
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetTokenResponse(
    appId: Option[__string] = None,
    challengeCode: Option[__string] = None,
    sessionId: Option[__string] = None,
    ttl: Option[__string] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.amplifybackend.model.GetTokenResponse = {
    import GetTokenResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplifybackend.model.GetTokenResponse
      .builder()
      .optionallyWith(appId.map(value => value: java.lang.String))(_.appId)
      .optionallyWith(challengeCode.map(value => value: java.lang.String))(
        _.challengeCode
      )
      .optionallyWith(sessionId.map(value => value: java.lang.String))(
        _.sessionId
      )
      .optionallyWith(ttl.map(value => value: java.lang.String))(_.ttl)
      .build()
  }
  def asReadOnly: zio.aws.amplifybackend.model.GetTokenResponse.ReadOnly =
    zio.aws.amplifybackend.model.GetTokenResponse.wrap(buildAwsValue())
}
object GetTokenResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.amplifybackend.model.GetTokenResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.amplifybackend.model.GetTokenResponse =
      zio.aws.amplifybackend.model.GetTokenResponse(
        appId.map(value => value),
        challengeCode.map(value => value),
        sessionId.map(value => value),
        ttl.map(value => value)
      )
    def appId: Option[__string]
    def challengeCode: Option[__string]
    def sessionId: Option[__string]
    def ttl: Option[__string]
    def getAppId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("appId", appId)
    def getChallengeCode: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("challengeCode", challengeCode)
    def getSessionId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("sessionId", sessionId)
    def getTtl: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("ttl", ttl)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplifybackend.model.GetTokenResponse
  ) extends zio.aws.amplifybackend.model.GetTokenResponse.ReadOnly {
    override val appId: Option[__string] =
      scala.Option(impl.appId()).map(value => value: __string)
    override val challengeCode: Option[__string] =
      scala.Option(impl.challengeCode()).map(value => value: __string)
    override val sessionId: Option[__string] =
      scala.Option(impl.sessionId()).map(value => value: __string)
    override val ttl: Option[__string] =
      scala.Option(impl.ttl()).map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplifybackend.model.GetTokenResponse
  ): zio.aws.amplifybackend.model.GetTokenResponse.ReadOnly = new Wrapper(impl)
}
