package zio.aws.amplifybackend.model
import zio.aws.amplifybackend.model.primitives.__string
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class BackendJobRespObj(
    appId: __string,
    backendEnvironmentName: __string,
    createTime: Option[__string] = None,
    error: Option[__string] = None,
    jobId: Option[__string] = None,
    operation: Option[__string] = None,
    status: Option[__string] = None,
    updateTime: Option[__string] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.amplifybackend.model.BackendJobRespObj = {
    import BackendJobRespObj.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplifybackend.model.BackendJobRespObj
      .builder()
      .appId(appId: java.lang.String)
      .backendEnvironmentName(backendEnvironmentName: java.lang.String)
      .optionallyWith(createTime.map(value => value: java.lang.String))(
        _.createTime
      )
      .optionallyWith(error.map(value => value: java.lang.String))(_.error)
      .optionallyWith(jobId.map(value => value: java.lang.String))(_.jobId)
      .optionallyWith(operation.map(value => value: java.lang.String))(
        _.operation
      )
      .optionallyWith(status.map(value => value: java.lang.String))(_.status)
      .optionallyWith(updateTime.map(value => value: java.lang.String))(
        _.updateTime
      )
      .build()
  }
  def asReadOnly: zio.aws.amplifybackend.model.BackendJobRespObj.ReadOnly =
    zio.aws.amplifybackend.model.BackendJobRespObj.wrap(buildAwsValue())
}
object BackendJobRespObj {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.amplifybackend.model.BackendJobRespObj
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.amplifybackend.model.BackendJobRespObj =
      zio.aws.amplifybackend.model.BackendJobRespObj(
        appId,
        backendEnvironmentName,
        createTime.map(value => value),
        error.map(value => value),
        jobId.map(value => value),
        operation.map(value => value),
        status.map(value => value),
        updateTime.map(value => value)
      )
    def appId: __string
    def backendEnvironmentName: __string
    def createTime: Option[__string]
    def error: Option[__string]
    def jobId: Option[__string]
    def operation: Option[__string]
    def status: Option[__string]
    def updateTime: Option[__string]
    def getAppId: ZIO[Any, Nothing, __string] = ZIO.succeed(appId)
    def getBackendEnvironmentName: ZIO[Any, Nothing, __string] =
      ZIO.succeed(backendEnvironmentName)
    def getCreateTime: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("createTime", createTime)
    def getError: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("error", error)
    def getJobId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("jobId", jobId)
    def getOperation: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("operation", operation)
    def getStatus: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("status", status)
    def getUpdateTime: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("updateTime", updateTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplifybackend.model.BackendJobRespObj
  ) extends zio.aws.amplifybackend.model.BackendJobRespObj.ReadOnly {
    override val appId: __string = impl.appId(): __string
    override val backendEnvironmentName: __string =
      impl.backendEnvironmentName(): __string
    override val createTime: Option[__string] =
      scala.Option(impl.createTime()).map(value => value: __string)
    override val error: Option[__string] =
      scala.Option(impl.error()).map(value => value: __string)
    override val jobId: Option[__string] =
      scala.Option(impl.jobId()).map(value => value: __string)
    override val operation: Option[__string] =
      scala.Option(impl.operation()).map(value => value: __string)
    override val status: Option[__string] =
      scala.Option(impl.status()).map(value => value: __string)
    override val updateTime: Option[__string] =
      scala.Option(impl.updateTime()).map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplifybackend.model.BackendJobRespObj
  ): zio.aws.amplifybackend.model.BackendJobRespObj.ReadOnly = new Wrapper(impl)
}
