package zio.aws.amplifybackend.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class UpdateBackendAuthMFAConfig(
    mfaMode: Option[zio.aws.amplifybackend.model.MFAMode] = None,
    settings: Option[zio.aws.amplifybackend.model.Settings] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.amplifybackend.model.UpdateBackendAuthMFAConfig = {
    import UpdateBackendAuthMFAConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplifybackend.model.UpdateBackendAuthMFAConfig
      .builder()
      .optionallyWith(mfaMode.map(value => value.unwrap))(_.mfaMode)
      .optionallyWith(settings.map(value => value.buildAwsValue()))(_.settings)
      .build()
  }
  def asReadOnly
      : zio.aws.amplifybackend.model.UpdateBackendAuthMFAConfig.ReadOnly =
    zio.aws.amplifybackend.model.UpdateBackendAuthMFAConfig
      .wrap(buildAwsValue())
}
object UpdateBackendAuthMFAConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.amplifybackend.model.UpdateBackendAuthMFAConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.amplifybackend.model.UpdateBackendAuthMFAConfig =
      zio.aws.amplifybackend.model.UpdateBackendAuthMFAConfig(
        mfaMode.map(value => value),
        settings.map(value => value.asEditable)
      )
    def mfaMode: Option[zio.aws.amplifybackend.model.MFAMode]
    def settings: Option[zio.aws.amplifybackend.model.Settings.ReadOnly]
    def getMfaMode: ZIO[Any, AwsError, zio.aws.amplifybackend.model.MFAMode] =
      AwsError.unwrapOptionField("mfaMode", mfaMode)
    def getSettings
        : ZIO[Any, AwsError, zio.aws.amplifybackend.model.Settings.ReadOnly] =
      AwsError.unwrapOptionField("settings", settings)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplifybackend.model.UpdateBackendAuthMFAConfig
  ) extends zio.aws.amplifybackend.model.UpdateBackendAuthMFAConfig.ReadOnly {
    override val mfaMode: Option[zio.aws.amplifybackend.model.MFAMode] = scala
      .Option(impl.mfaMode())
      .map(value => zio.aws.amplifybackend.model.MFAMode.wrap(value))
    override val settings
        : Option[zio.aws.amplifybackend.model.Settings.ReadOnly] = scala
      .Option(impl.settings())
      .map(value => zio.aws.amplifybackend.model.Settings.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplifybackend.model.UpdateBackendAuthMFAConfig
  ): zio.aws.amplifybackend.model.UpdateBackendAuthMFAConfig.ReadOnly =
    new Wrapper(impl)
}
