package zio.aws.amplifybackend.model
import scala.jdk.CollectionConverters.*
sealed trait Status {
  def unwrap: software.amazon.awssdk.services.amplifybackend.model.Status
}
object Status {
  def wrap(
      value: software.amazon.awssdk.services.amplifybackend.model.Status
  ): zio.aws.amplifybackend.model.Status = value match {
    case software.amazon.awssdk.services.amplifybackend.model.Status.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.amplifybackend.model.Status.LATEST =>
      val r = LATEST
      r
    case software.amazon.awssdk.services.amplifybackend.model.Status.STALE =>
      val r = STALE
      r
  }
  case object unknownToSdkVersion extends zio.aws.amplifybackend.model.Status {
    override def unwrap
        : software.amazon.awssdk.services.amplifybackend.model.Status =
      software.amazon.awssdk.services.amplifybackend.model.Status.UNKNOWN_TO_SDK_VERSION
  }
  case object LATEST extends zio.aws.amplifybackend.model.Status {
    override def unwrap
        : software.amazon.awssdk.services.amplifybackend.model.Status =
      software.amazon.awssdk.services.amplifybackend.model.Status.LATEST
  }
  case object STALE extends zio.aws.amplifybackend.model.Status {
    override def unwrap
        : software.amazon.awssdk.services.amplifybackend.model.Status =
      software.amazon.awssdk.services.amplifybackend.model.Status.STALE
  }
}
