package zio.aws.amplifybackend.model
import zio.aws.amplifybackend.model.primitives.__string
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class S3BucketInfo(
    creationDate: Option[__string] = None,
    name: Option[__string] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.amplifybackend.model.S3BucketInfo = {
    import S3BucketInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplifybackend.model.S3BucketInfo
      .builder()
      .optionallyWith(creationDate.map(value => value: java.lang.String))(
        _.creationDate
      )
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .build()
  }
  def asReadOnly: zio.aws.amplifybackend.model.S3BucketInfo.ReadOnly =
    zio.aws.amplifybackend.model.S3BucketInfo.wrap(buildAwsValue())
}
object S3BucketInfo {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.amplifybackend.model.S3BucketInfo
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.amplifybackend.model.S3BucketInfo =
      zio.aws.amplifybackend.model.S3BucketInfo(
        creationDate.map(value => value),
        name.map(value => value)
      )
    def creationDate: Option[__string]
    def name: Option[__string]
    def getCreationDate: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("creationDate", creationDate)
    def getName: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("name", name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplifybackend.model.S3BucketInfo
  ) extends zio.aws.amplifybackend.model.S3BucketInfo.ReadOnly {
    override val creationDate: Option[__string] =
      scala.Option(impl.creationDate()).map(value => value: __string)
    override val name: Option[__string] =
      scala.Option(impl.name()).map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplifybackend.model.S3BucketInfo
  ): zio.aws.amplifybackend.model.S3BucketInfo.ReadOnly = new Wrapper(impl)
}
