package zio.aws.amplifybackend.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class SocialProviderSettings(
    facebook: Option[
      zio.aws.amplifybackend.model.BackendAuthSocialProviderConfig
    ] = None,
    google: Option[
      zio.aws.amplifybackend.model.BackendAuthSocialProviderConfig
    ] = None,
    loginWithAmazon: Option[
      zio.aws.amplifybackend.model.BackendAuthSocialProviderConfig
    ] = None,
    signInWithApple: Option[
      zio.aws.amplifybackend.model.BackendAuthAppleProviderConfig
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.amplifybackend.model.SocialProviderSettings = {
    import SocialProviderSettings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplifybackend.model.SocialProviderSettings
      .builder()
      .optionallyWith(facebook.map(value => value.buildAwsValue()))(_.facebook)
      .optionallyWith(google.map(value => value.buildAwsValue()))(_.google)
      .optionallyWith(loginWithAmazon.map(value => value.buildAwsValue()))(
        _.loginWithAmazon
      )
      .optionallyWith(signInWithApple.map(value => value.buildAwsValue()))(
        _.signInWithApple
      )
      .build()
  }
  def asReadOnly: zio.aws.amplifybackend.model.SocialProviderSettings.ReadOnly =
    zio.aws.amplifybackend.model.SocialProviderSettings.wrap(buildAwsValue())
}
object SocialProviderSettings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.amplifybackend.model.SocialProviderSettings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.amplifybackend.model.SocialProviderSettings =
      zio.aws.amplifybackend.model.SocialProviderSettings(
        facebook.map(value => value.asEditable),
        google.map(value => value.asEditable),
        loginWithAmazon.map(value => value.asEditable),
        signInWithApple.map(value => value.asEditable)
      )
    def facebook: Option[
      zio.aws.amplifybackend.model.BackendAuthSocialProviderConfig.ReadOnly
    ]
    def google: Option[
      zio.aws.amplifybackend.model.BackendAuthSocialProviderConfig.ReadOnly
    ]
    def loginWithAmazon: Option[
      zio.aws.amplifybackend.model.BackendAuthSocialProviderConfig.ReadOnly
    ]
    def signInWithApple: Option[
      zio.aws.amplifybackend.model.BackendAuthAppleProviderConfig.ReadOnly
    ]
    def getFacebook: ZIO[
      Any,
      AwsError,
      zio.aws.amplifybackend.model.BackendAuthSocialProviderConfig.ReadOnly
    ] = AwsError.unwrapOptionField("facebook", facebook)
    def getGoogle: ZIO[
      Any,
      AwsError,
      zio.aws.amplifybackend.model.BackendAuthSocialProviderConfig.ReadOnly
    ] = AwsError.unwrapOptionField("google", google)
    def getLoginWithAmazon: ZIO[
      Any,
      AwsError,
      zio.aws.amplifybackend.model.BackendAuthSocialProviderConfig.ReadOnly
    ] = AwsError.unwrapOptionField("loginWithAmazon", loginWithAmazon)
    def getSignInWithApple: ZIO[
      Any,
      AwsError,
      zio.aws.amplifybackend.model.BackendAuthAppleProviderConfig.ReadOnly
    ] = AwsError.unwrapOptionField("signInWithApple", signInWithApple)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplifybackend.model.SocialProviderSettings
  ) extends zio.aws.amplifybackend.model.SocialProviderSettings.ReadOnly {
    override val facebook: Option[
      zio.aws.amplifybackend.model.BackendAuthSocialProviderConfig.ReadOnly
    ] = scala
      .Option(impl.facebook())
      .map(value =>
        zio.aws.amplifybackend.model.BackendAuthSocialProviderConfig.wrap(value)
      )
    override val google: Option[
      zio.aws.amplifybackend.model.BackendAuthSocialProviderConfig.ReadOnly
    ] = scala
      .Option(impl.google())
      .map(value =>
        zio.aws.amplifybackend.model.BackendAuthSocialProviderConfig.wrap(value)
      )
    override val loginWithAmazon: Option[
      zio.aws.amplifybackend.model.BackendAuthSocialProviderConfig.ReadOnly
    ] = scala
      .Option(impl.loginWithAmazon())
      .map(value =>
        zio.aws.amplifybackend.model.BackendAuthSocialProviderConfig.wrap(value)
      )
    override val signInWithApple: Option[
      zio.aws.amplifybackend.model.BackendAuthAppleProviderConfig.ReadOnly
    ] = scala
      .Option(impl.signInWithApple())
      .map(value =>
        zio.aws.amplifybackend.model.BackendAuthAppleProviderConfig.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplifybackend.model.SocialProviderSettings
  ): zio.aws.amplifybackend.model.SocialProviderSettings.ReadOnly = new Wrapper(
    impl
  )
}
