package zio.aws.amplifybackend.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class UpdateBackendAuthForgotPasswordConfig(
    deliveryMethod: Option[zio.aws.amplifybackend.model.DeliveryMethod] = None,
    emailSettings: Option[zio.aws.amplifybackend.model.EmailSettings] = None,
    smsSettings: Option[zio.aws.amplifybackend.model.SmsSettings] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.amplifybackend.model.UpdateBackendAuthForgotPasswordConfig = {
    import UpdateBackendAuthForgotPasswordConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplifybackend.model.UpdateBackendAuthForgotPasswordConfig
      .builder()
      .optionallyWith(deliveryMethod.map(value => value.unwrap))(
        _.deliveryMethod
      )
      .optionallyWith(emailSettings.map(value => value.buildAwsValue()))(
        _.emailSettings
      )
      .optionallyWith(smsSettings.map(value => value.buildAwsValue()))(
        _.smsSettings
      )
      .build()
  }
  def asReadOnly
      : zio.aws.amplifybackend.model.UpdateBackendAuthForgotPasswordConfig.ReadOnly =
    zio.aws.amplifybackend.model.UpdateBackendAuthForgotPasswordConfig
      .wrap(buildAwsValue())
}
object UpdateBackendAuthForgotPasswordConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.amplifybackend.model.UpdateBackendAuthForgotPasswordConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.amplifybackend.model.UpdateBackendAuthForgotPasswordConfig =
      zio.aws.amplifybackend.model.UpdateBackendAuthForgotPasswordConfig(
        deliveryMethod.map(value => value),
        emailSettings.map(value => value.asEditable),
        smsSettings.map(value => value.asEditable)
      )
    def deliveryMethod: Option[zio.aws.amplifybackend.model.DeliveryMethod]
    def emailSettings
        : Option[zio.aws.amplifybackend.model.EmailSettings.ReadOnly]
    def smsSettings: Option[zio.aws.amplifybackend.model.SmsSettings.ReadOnly]
    def getDeliveryMethod
        : ZIO[Any, AwsError, zio.aws.amplifybackend.model.DeliveryMethod] =
      AwsError.unwrapOptionField("deliveryMethod", deliveryMethod)
    def getEmailSettings: ZIO[
      Any,
      AwsError,
      zio.aws.amplifybackend.model.EmailSettings.ReadOnly
    ] = AwsError.unwrapOptionField("emailSettings", emailSettings)
    def getSmsSettings: ZIO[
      Any,
      AwsError,
      zio.aws.amplifybackend.model.SmsSettings.ReadOnly
    ] = AwsError.unwrapOptionField("smsSettings", smsSettings)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplifybackend.model.UpdateBackendAuthForgotPasswordConfig
  ) extends zio.aws.amplifybackend.model.UpdateBackendAuthForgotPasswordConfig.ReadOnly {
    override val deliveryMethod
        : Option[zio.aws.amplifybackend.model.DeliveryMethod] = scala
      .Option(impl.deliveryMethod())
      .map(value => zio.aws.amplifybackend.model.DeliveryMethod.wrap(value))
    override val emailSettings
        : Option[zio.aws.amplifybackend.model.EmailSettings.ReadOnly] = scala
      .Option(impl.emailSettings())
      .map(value => zio.aws.amplifybackend.model.EmailSettings.wrap(value))
    override val smsSettings
        : Option[zio.aws.amplifybackend.model.SmsSettings.ReadOnly] = scala
      .Option(impl.smsSettings())
      .map(value => zio.aws.amplifybackend.model.SmsSettings.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplifybackend.model.UpdateBackendAuthForgotPasswordConfig
  ): zio.aws.amplifybackend.model.UpdateBackendAuthForgotPasswordConfig.ReadOnly =
    new Wrapper(impl)
}
