package zio.aws.amplifybackend.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class UpdateBackendStorageResourceConfig(
    permissions: zio.aws.amplifybackend.model.BackendStoragePermissions,
    serviceName: zio.aws.amplifybackend.model.ServiceName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.amplifybackend.model.UpdateBackendStorageResourceConfig = {
    import UpdateBackendStorageResourceConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplifybackend.model.UpdateBackendStorageResourceConfig
      .builder()
      .permissions(permissions.buildAwsValue())
      .serviceName(serviceName.unwrap)
      .build()
  }
  def asReadOnly
      : zio.aws.amplifybackend.model.UpdateBackendStorageResourceConfig.ReadOnly =
    zio.aws.amplifybackend.model.UpdateBackendStorageResourceConfig
      .wrap(buildAwsValue())
}
object UpdateBackendStorageResourceConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.amplifybackend.model.UpdateBackendStorageResourceConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.amplifybackend.model.UpdateBackendStorageResourceConfig =
      zio.aws.amplifybackend.model
        .UpdateBackendStorageResourceConfig(permissions.asEditable, serviceName)
    def permissions
        : zio.aws.amplifybackend.model.BackendStoragePermissions.ReadOnly
    def serviceName: zio.aws.amplifybackend.model.ServiceName
    def getPermissions: ZIO[
      Any,
      Nothing,
      zio.aws.amplifybackend.model.BackendStoragePermissions.ReadOnly
    ] = ZIO.succeed(permissions)
    def getServiceName
        : ZIO[Any, Nothing, zio.aws.amplifybackend.model.ServiceName] =
      ZIO.succeed(serviceName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplifybackend.model.UpdateBackendStorageResourceConfig
  ) extends zio.aws.amplifybackend.model.UpdateBackendStorageResourceConfig.ReadOnly {
    override val permissions
        : zio.aws.amplifybackend.model.BackendStoragePermissions.ReadOnly =
      zio.aws.amplifybackend.model.BackendStoragePermissions
        .wrap(impl.permissions())
    override val serviceName: zio.aws.amplifybackend.model.ServiceName =
      zio.aws.amplifybackend.model.ServiceName.wrap(impl.serviceName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplifybackend.model.UpdateBackendStorageResourceConfig
  ): zio.aws.amplifybackend.model.UpdateBackendStorageResourceConfig.ReadOnly =
    new Wrapper(impl)
}
