package zio.aws.amplifybackend.model
import scala.jdk.CollectionConverters.*
sealed trait ServiceName {
  def unwrap: software.amazon.awssdk.services.amplifybackend.model.ServiceName
}
object ServiceName {
  def wrap(
      value: software.amazon.awssdk.services.amplifybackend.model.ServiceName
  ): zio.aws.amplifybackend.model.ServiceName = value match {
    case software.amazon.awssdk.services.amplifybackend.model.ServiceName.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.amplifybackend.model.ServiceName.S3 =>
      val r = S3
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.amplifybackend.model.ServiceName {
    override def unwrap
        : software.amazon.awssdk.services.amplifybackend.model.ServiceName =
      software.amazon.awssdk.services.amplifybackend.model.ServiceName.UNKNOWN_TO_SDK_VERSION
  }
  case object S3 extends zio.aws.amplifybackend.model.ServiceName {
    override def unwrap
        : software.amazon.awssdk.services.amplifybackend.model.ServiceName =
      software.amazon.awssdk.services.amplifybackend.model.ServiceName.S3
  }
}
