package zio.aws.amplifybackend.model
import zio.aws.amplifybackend.model.primitives.__string
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class GetBackendJobRequest(
    appId: __string,
    backendEnvironmentName: __string,
    jobId: __string
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.amplifybackend.model.GetBackendJobRequest = {
    import GetBackendJobRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplifybackend.model.GetBackendJobRequest
      .builder()
      .appId(__string.unwrap(appId): java.lang.String)
      .backendEnvironmentName(
        __string.unwrap(backendEnvironmentName): java.lang.String
      )
      .jobId(__string.unwrap(jobId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.amplifybackend.model.GetBackendJobRequest.ReadOnly =
    zio.aws.amplifybackend.model.GetBackendJobRequest.wrap(buildAwsValue())
}
object GetBackendJobRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.amplifybackend.model.GetBackendJobRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.amplifybackend.model.GetBackendJobRequest =
      zio.aws.amplifybackend.model
        .GetBackendJobRequest(appId, backendEnvironmentName, jobId)
    def appId: __string
    def backendEnvironmentName: __string
    def jobId: __string
    def getAppId: ZIO[Any, Nothing, __string] = ZIO.succeed(appId)
    def getBackendEnvironmentName: ZIO[Any, Nothing, __string] =
      ZIO.succeed(backendEnvironmentName)
    def getJobId: ZIO[Any, Nothing, __string] = ZIO.succeed(jobId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplifybackend.model.GetBackendJobRequest
  ) extends zio.aws.amplifybackend.model.GetBackendJobRequest.ReadOnly {
    override val appId: __string =
      zio.aws.amplifybackend.model.primitives.__string(impl.appId())
    override val backendEnvironmentName: __string =
      zio.aws.amplifybackend.model.primitives
        .__string(impl.backendEnvironmentName())
    override val jobId: __string =
      zio.aws.amplifybackend.model.primitives.__string(impl.jobId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplifybackend.model.GetBackendJobRequest
  ): zio.aws.amplifybackend.model.GetBackendJobRequest.ReadOnly = new Wrapper(
    impl
  )
}
