package zio.aws.amplifybackend.model
import zio.aws.amplifybackend.model.primitives.{__boolean, __string}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class RemoveAllBackendsRequest(
    appId: __string,
    cleanAmplifyApp: Option[__boolean] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.amplifybackend.model.RemoveAllBackendsRequest = {
    import RemoveAllBackendsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplifybackend.model.RemoveAllBackendsRequest
      .builder()
      .appId(__string.unwrap(appId): java.lang.String)
      .optionallyWith(
        cleanAmplifyApp.map(value => __boolean.unwrap(value): java.lang.Boolean)
      )(_.cleanAmplifyApp)
      .build()
  }
  def asReadOnly
      : zio.aws.amplifybackend.model.RemoveAllBackendsRequest.ReadOnly =
    zio.aws.amplifybackend.model.RemoveAllBackendsRequest.wrap(buildAwsValue())
}
object RemoveAllBackendsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.amplifybackend.model.RemoveAllBackendsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.amplifybackend.model.RemoveAllBackendsRequest =
      zio.aws.amplifybackend.model
        .RemoveAllBackendsRequest(appId, cleanAmplifyApp.map(value => value))
    def appId: __string
    def cleanAmplifyApp: Option[__boolean]
    def getAppId: ZIO[Any, Nothing, __string] = ZIO.succeed(appId)
    def getCleanAmplifyApp: ZIO[Any, AwsError, __boolean] =
      AwsError.unwrapOptionField("cleanAmplifyApp", cleanAmplifyApp)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplifybackend.model.RemoveAllBackendsRequest
  ) extends zio.aws.amplifybackend.model.RemoveAllBackendsRequest.ReadOnly {
    override val appId: __string =
      zio.aws.amplifybackend.model.primitives.__string(impl.appId())
    override val cleanAmplifyApp: Option[__boolean] = scala
      .Option(impl.cleanAmplifyApp())
      .map(value => zio.aws.amplifybackend.model.primitives.__boolean(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplifybackend.model.RemoveAllBackendsRequest
  ): zio.aws.amplifybackend.model.RemoveAllBackendsRequest.ReadOnly =
    new Wrapper(impl)
}
