package zio.aws.amplifybackend.model
import zio.aws.amplifybackend.model.primitives.__string
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetBackendAuthResponse(
    appId: Option[__string] = None,
    backendEnvironmentName: Option[__string] = None,
    error: Option[__string] = None,
    resourceConfig: Option[
      zio.aws.amplifybackend.model.CreateBackendAuthResourceConfig
    ] = None,
    resourceName: Option[__string] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.amplifybackend.model.GetBackendAuthResponse = {
    import GetBackendAuthResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplifybackend.model.GetBackendAuthResponse
      .builder()
      .optionallyWith(
        appId.map(value => __string.unwrap(value): java.lang.String)
      )(_.appId)
      .optionallyWith(
        backendEnvironmentName.map(value =>
          __string.unwrap(value): java.lang.String
        )
      )(_.backendEnvironmentName)
      .optionallyWith(
        error.map(value => __string.unwrap(value): java.lang.String)
      )(_.error)
      .optionallyWith(resourceConfig.map(value => value.buildAwsValue()))(
        _.resourceConfig
      )
      .optionallyWith(
        resourceName.map(value => __string.unwrap(value): java.lang.String)
      )(_.resourceName)
      .build()
  }
  def asReadOnly: zio.aws.amplifybackend.model.GetBackendAuthResponse.ReadOnly =
    zio.aws.amplifybackend.model.GetBackendAuthResponse.wrap(buildAwsValue())
}
object GetBackendAuthResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.amplifybackend.model.GetBackendAuthResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.amplifybackend.model.GetBackendAuthResponse =
      zio.aws.amplifybackend.model.GetBackendAuthResponse(
        appId.map(value => value),
        backendEnvironmentName.map(value => value),
        error.map(value => value),
        resourceConfig.map(value => value.asEditable),
        resourceName.map(value => value)
      )
    def appId: Option[__string]
    def backendEnvironmentName: Option[__string]
    def error: Option[__string]
    def resourceConfig: Option[
      zio.aws.amplifybackend.model.CreateBackendAuthResourceConfig.ReadOnly
    ]
    def resourceName: Option[__string]
    def getAppId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("appId", appId)
    def getBackendEnvironmentName: ZIO[Any, AwsError, __string] = AwsError
      .unwrapOptionField("backendEnvironmentName", backendEnvironmentName)
    def getError: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("error", error)
    def getResourceConfig: ZIO[
      Any,
      AwsError,
      zio.aws.amplifybackend.model.CreateBackendAuthResourceConfig.ReadOnly
    ] = AwsError.unwrapOptionField("resourceConfig", resourceConfig)
    def getResourceName: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("resourceName", resourceName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplifybackend.model.GetBackendAuthResponse
  ) extends zio.aws.amplifybackend.model.GetBackendAuthResponse.ReadOnly {
    override val appId: Option[__string] = scala
      .Option(impl.appId())
      .map(value => zio.aws.amplifybackend.model.primitives.__string(value))
    override val backendEnvironmentName: Option[__string] = scala
      .Option(impl.backendEnvironmentName())
      .map(value => zio.aws.amplifybackend.model.primitives.__string(value))
    override val error: Option[__string] = scala
      .Option(impl.error())
      .map(value => zio.aws.amplifybackend.model.primitives.__string(value))
    override val resourceConfig: Option[
      zio.aws.amplifybackend.model.CreateBackendAuthResourceConfig.ReadOnly
    ] = scala
      .Option(impl.resourceConfig())
      .map(value =>
        zio.aws.amplifybackend.model.CreateBackendAuthResourceConfig.wrap(value)
      )
    override val resourceName: Option[__string] = scala
      .Option(impl.resourceName())
      .map(value => zio.aws.amplifybackend.model.primitives.__string(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplifybackend.model.GetBackendAuthResponse
  ): zio.aws.amplifybackend.model.GetBackendAuthResponse.ReadOnly = new Wrapper(
    impl
  )
}
