package zio.aws.amplifybackend.model
import zio.aws.amplifybackend.model.primitives.__string
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CreateBackendStorageResourceConfig(
    bucketName: Option[__string] = None,
    permissions: zio.aws.amplifybackend.model.BackendStoragePermissions,
    serviceName: zio.aws.amplifybackend.model.ServiceName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.amplifybackend.model.CreateBackendStorageResourceConfig = {
    import CreateBackendStorageResourceConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplifybackend.model.CreateBackendStorageResourceConfig
      .builder()
      .optionallyWith(
        bucketName.map(value => __string.unwrap(value): java.lang.String)
      )(_.bucketName)
      .permissions(permissions.buildAwsValue())
      .serviceName(serviceName.unwrap)
      .build()
  }
  def asReadOnly
      : zio.aws.amplifybackend.model.CreateBackendStorageResourceConfig.ReadOnly =
    zio.aws.amplifybackend.model.CreateBackendStorageResourceConfig
      .wrap(buildAwsValue())
}
object CreateBackendStorageResourceConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.amplifybackend.model.CreateBackendStorageResourceConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.amplifybackend.model.CreateBackendStorageResourceConfig =
      zio.aws.amplifybackend.model.CreateBackendStorageResourceConfig(
        bucketName.map(value => value),
        permissions.asEditable,
        serviceName
      )
    def bucketName: Option[__string]
    def permissions
        : zio.aws.amplifybackend.model.BackendStoragePermissions.ReadOnly
    def serviceName: zio.aws.amplifybackend.model.ServiceName
    def getBucketName: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("bucketName", bucketName)
    def getPermissions: ZIO[
      Any,
      Nothing,
      zio.aws.amplifybackend.model.BackendStoragePermissions.ReadOnly
    ] = ZIO.succeed(permissions)
    def getServiceName
        : ZIO[Any, Nothing, zio.aws.amplifybackend.model.ServiceName] =
      ZIO.succeed(serviceName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplifybackend.model.CreateBackendStorageResourceConfig
  ) extends zio.aws.amplifybackend.model.CreateBackendStorageResourceConfig.ReadOnly {
    override val bucketName: Option[__string] = scala
      .Option(impl.bucketName())
      .map(value => zio.aws.amplifybackend.model.primitives.__string(value))
    override val permissions
        : zio.aws.amplifybackend.model.BackendStoragePermissions.ReadOnly =
      zio.aws.amplifybackend.model.BackendStoragePermissions
        .wrap(impl.permissions())
    override val serviceName: zio.aws.amplifybackend.model.ServiceName =
      zio.aws.amplifybackend.model.ServiceName.wrap(impl.serviceName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplifybackend.model.CreateBackendStorageResourceConfig
  ): zio.aws.amplifybackend.model.CreateBackendStorageResourceConfig.ReadOnly =
    new Wrapper(impl)
}
