package zio.aws.amplifybackend.model
import zio.aws.amplifybackend.model.primitives.__string
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListS3BucketsResponse(
    buckets: Option[Iterable[zio.aws.amplifybackend.model.S3BucketInfo]] = None,
    nextToken: Option[__string] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.amplifybackend.model.ListS3BucketsResponse = {
    import ListS3BucketsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplifybackend.model.ListS3BucketsResponse
      .builder()
      .optionallyWith(
        buckets.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.buckets)
      .optionallyWith(
        nextToken.map(value => __string.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.amplifybackend.model.ListS3BucketsResponse.ReadOnly =
    zio.aws.amplifybackend.model.ListS3BucketsResponse.wrap(buildAwsValue())
}
object ListS3BucketsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.amplifybackend.model.ListS3BucketsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.amplifybackend.model.ListS3BucketsResponse =
      zio.aws.amplifybackend.model.ListS3BucketsResponse(
        buckets.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def buckets
        : Option[List[zio.aws.amplifybackend.model.S3BucketInfo.ReadOnly]]
    def nextToken: Option[__string]
    def getBuckets: ZIO[Any, AwsError, List[
      zio.aws.amplifybackend.model.S3BucketInfo.ReadOnly
    ]] = AwsError.unwrapOptionField("buckets", buckets)
    def getNextToken: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplifybackend.model.ListS3BucketsResponse
  ) extends zio.aws.amplifybackend.model.ListS3BucketsResponse.ReadOnly {
    override val buckets
        : Option[List[zio.aws.amplifybackend.model.S3BucketInfo.ReadOnly]] =
      scala
        .Option(impl.buckets())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.amplifybackend.model.S3BucketInfo.wrap(item)
          }.toList
        )
    override val nextToken: Option[__string] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.amplifybackend.model.primitives.__string(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplifybackend.model.ListS3BucketsResponse
  ): zio.aws.amplifybackend.model.ListS3BucketsResponse.ReadOnly = new Wrapper(
    impl
  )
}
