package zio.aws.amplifybackend.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CreateBackendAuthResourceConfig(
    authResources: zio.aws.amplifybackend.model.AuthResources,
    identityPoolConfigs: Option[
      zio.aws.amplifybackend.model.CreateBackendAuthIdentityPoolConfig
    ] = None,
    service: zio.aws.amplifybackend.model.Service,
    userPoolConfigs: zio.aws.amplifybackend.model.CreateBackendAuthUserPoolConfig
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.amplifybackend.model.CreateBackendAuthResourceConfig = {
    import CreateBackendAuthResourceConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplifybackend.model.CreateBackendAuthResourceConfig
      .builder()
      .authResources(authResources.unwrap)
      .optionallyWith(identityPoolConfigs.map(value => value.buildAwsValue()))(
        _.identityPoolConfigs
      )
      .service(service.unwrap)
      .userPoolConfigs(userPoolConfigs.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.amplifybackend.model.CreateBackendAuthResourceConfig.ReadOnly =
    zio.aws.amplifybackend.model.CreateBackendAuthResourceConfig
      .wrap(buildAwsValue())
}
object CreateBackendAuthResourceConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.amplifybackend.model.CreateBackendAuthResourceConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.amplifybackend.model.CreateBackendAuthResourceConfig =
      zio.aws.amplifybackend.model.CreateBackendAuthResourceConfig(
        authResources,
        identityPoolConfigs.map(value => value.asEditable),
        service,
        userPoolConfigs.asEditable
      )
    def authResources: zio.aws.amplifybackend.model.AuthResources
    def identityPoolConfigs: Option[
      zio.aws.amplifybackend.model.CreateBackendAuthIdentityPoolConfig.ReadOnly
    ]
    def service: zio.aws.amplifybackend.model.Service
    def userPoolConfigs
        : zio.aws.amplifybackend.model.CreateBackendAuthUserPoolConfig.ReadOnly
    def getAuthResources
        : ZIO[Any, Nothing, zio.aws.amplifybackend.model.AuthResources] =
      ZIO.succeed(authResources)
    def getIdentityPoolConfigs: ZIO[
      Any,
      AwsError,
      zio.aws.amplifybackend.model.CreateBackendAuthIdentityPoolConfig.ReadOnly
    ] = AwsError.unwrapOptionField("identityPoolConfigs", identityPoolConfigs)
    def getService: ZIO[Any, Nothing, zio.aws.amplifybackend.model.Service] =
      ZIO.succeed(service)
    def getUserPoolConfigs: ZIO[
      Any,
      Nothing,
      zio.aws.amplifybackend.model.CreateBackendAuthUserPoolConfig.ReadOnly
    ] = ZIO.succeed(userPoolConfigs)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplifybackend.model.CreateBackendAuthResourceConfig
  ) extends zio.aws.amplifybackend.model.CreateBackendAuthResourceConfig.ReadOnly {
    override val authResources: zio.aws.amplifybackend.model.AuthResources =
      zio.aws.amplifybackend.model.AuthResources.wrap(impl.authResources())
    override val identityPoolConfigs: Option[
      zio.aws.amplifybackend.model.CreateBackendAuthIdentityPoolConfig.ReadOnly
    ] = scala
      .Option(impl.identityPoolConfigs())
      .map(value =>
        zio.aws.amplifybackend.model.CreateBackendAuthIdentityPoolConfig
          .wrap(value)
      )
    override val service: zio.aws.amplifybackend.model.Service =
      zio.aws.amplifybackend.model.Service.wrap(impl.service())
    override val userPoolConfigs
        : zio.aws.amplifybackend.model.CreateBackendAuthUserPoolConfig.ReadOnly =
      zio.aws.amplifybackend.model.CreateBackendAuthUserPoolConfig
        .wrap(impl.userPoolConfigs())
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplifybackend.model.CreateBackendAuthResourceConfig
  ): zio.aws.amplifybackend.model.CreateBackendAuthResourceConfig.ReadOnly =
    new Wrapper(impl)
}
