package zio.aws.amplifybackend.model
import scala.jdk.CollectionConverters.*
sealed trait AuthResources {
  def unwrap: software.amazon.awssdk.services.amplifybackend.model.AuthResources
}
object AuthResources {
  def wrap(
      value: software.amazon.awssdk.services.amplifybackend.model.AuthResources
  ): zio.aws.amplifybackend.model.AuthResources = value match {
    case software.amazon.awssdk.services.amplifybackend.model.AuthResources.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.amplifybackend.model.AuthResources.USER_POOL_ONLY =>
      val r = USER_POOL_ONLY
      r
    case software.amazon.awssdk.services.amplifybackend.model.AuthResources.IDENTITY_POOL_AND_USER_POOL =>
      val r = IDENTITY_POOL_AND_USER_POOL
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.amplifybackend.model.AuthResources {
    override def unwrap
        : software.amazon.awssdk.services.amplifybackend.model.AuthResources =
      software.amazon.awssdk.services.amplifybackend.model.AuthResources.UNKNOWN_TO_SDK_VERSION
  }
  case object USER_POOL_ONLY
      extends zio.aws.amplifybackend.model.AuthResources {
    override def unwrap
        : software.amazon.awssdk.services.amplifybackend.model.AuthResources =
      software.amazon.awssdk.services.amplifybackend.model.AuthResources.USER_POOL_ONLY
  }
  case object IDENTITY_POOL_AND_USER_POOL
      extends zio.aws.amplifybackend.model.AuthResources {
    override def unwrap
        : software.amazon.awssdk.services.amplifybackend.model.AuthResources =
      software.amazon.awssdk.services.amplifybackend.model.AuthResources.IDENTITY_POOL_AND_USER_POOL
  }
}
