package zio.aws.amplifybackend.model
import zio.aws.amplifybackend.model.primitives.__string
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class UpdateBackendConfigResponse(
    appId: Option[__string] = None,
    backendManagerAppId: Option[__string] = None,
    error: Option[__string] = None,
    loginAuthConfig: Option[
      zio.aws.amplifybackend.model.LoginAuthConfigReqObj
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.amplifybackend.model.UpdateBackendConfigResponse = {
    import UpdateBackendConfigResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplifybackend.model.UpdateBackendConfigResponse
      .builder()
      .optionallyWith(
        appId.map(value => __string.unwrap(value): java.lang.String)
      )(_.appId)
      .optionallyWith(
        backendManagerAppId.map(value =>
          __string.unwrap(value): java.lang.String
        )
      )(_.backendManagerAppId)
      .optionallyWith(
        error.map(value => __string.unwrap(value): java.lang.String)
      )(_.error)
      .optionallyWith(loginAuthConfig.map(value => value.buildAwsValue()))(
        _.loginAuthConfig
      )
      .build()
  }
  def asReadOnly
      : zio.aws.amplifybackend.model.UpdateBackendConfigResponse.ReadOnly =
    zio.aws.amplifybackend.model.UpdateBackendConfigResponse
      .wrap(buildAwsValue())
}
object UpdateBackendConfigResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.amplifybackend.model.UpdateBackendConfigResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.amplifybackend.model.UpdateBackendConfigResponse =
      zio.aws.amplifybackend.model.UpdateBackendConfigResponse(
        appId.map(value => value),
        backendManagerAppId.map(value => value),
        error.map(value => value),
        loginAuthConfig.map(value => value.asEditable)
      )
    def appId: Option[__string]
    def backendManagerAppId: Option[__string]
    def error: Option[__string]
    def loginAuthConfig
        : Option[zio.aws.amplifybackend.model.LoginAuthConfigReqObj.ReadOnly]
    def getAppId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("appId", appId)
    def getBackendManagerAppId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("backendManagerAppId", backendManagerAppId)
    def getError: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("error", error)
    def getLoginAuthConfig: ZIO[
      Any,
      AwsError,
      zio.aws.amplifybackend.model.LoginAuthConfigReqObj.ReadOnly
    ] = AwsError.unwrapOptionField("loginAuthConfig", loginAuthConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplifybackend.model.UpdateBackendConfigResponse
  ) extends zio.aws.amplifybackend.model.UpdateBackendConfigResponse.ReadOnly {
    override val appId: Option[__string] = scala
      .Option(impl.appId())
      .map(value => zio.aws.amplifybackend.model.primitives.__string(value))
    override val backendManagerAppId: Option[__string] = scala
      .Option(impl.backendManagerAppId())
      .map(value => zio.aws.amplifybackend.model.primitives.__string(value))
    override val error: Option[__string] = scala
      .Option(impl.error())
      .map(value => zio.aws.amplifybackend.model.primitives.__string(value))
    override val loginAuthConfig
        : Option[zio.aws.amplifybackend.model.LoginAuthConfigReqObj.ReadOnly] =
      scala
        .Option(impl.loginAuthConfig())
        .map(value =>
          zio.aws.amplifybackend.model.LoginAuthConfigReqObj.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplifybackend.model.UpdateBackendConfigResponse
  ): zio.aws.amplifybackend.model.UpdateBackendConfigResponse.ReadOnly =
    new Wrapper(impl)
}
