package zio.aws.amplifybackend.model
import zio.aws.amplifybackend.model.primitives.__string
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class BackendAuthAppleProviderConfig(
    clientId: Option[__string] = None,
    keyId: Option[__string] = None,
    privateKey: Option[__string] = None,
    teamId: Option[__string] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.amplifybackend.model.BackendAuthAppleProviderConfig = {
    import BackendAuthAppleProviderConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplifybackend.model.BackendAuthAppleProviderConfig
      .builder()
      .optionallyWith(
        clientId.map(value => __string.unwrap(value): java.lang.String)
      )(_.clientId)
      .optionallyWith(
        keyId.map(value => __string.unwrap(value): java.lang.String)
      )(_.keyId)
      .optionallyWith(
        privateKey.map(value => __string.unwrap(value): java.lang.String)
      )(_.privateKey)
      .optionallyWith(
        teamId.map(value => __string.unwrap(value): java.lang.String)
      )(_.teamId)
      .build()
  }
  def asReadOnly
      : zio.aws.amplifybackend.model.BackendAuthAppleProviderConfig.ReadOnly =
    zio.aws.amplifybackend.model.BackendAuthAppleProviderConfig
      .wrap(buildAwsValue())
}
object BackendAuthAppleProviderConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.amplifybackend.model.BackendAuthAppleProviderConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.amplifybackend.model.BackendAuthAppleProviderConfig =
      zio.aws.amplifybackend.model.BackendAuthAppleProviderConfig(
        clientId.map(value => value),
        keyId.map(value => value),
        privateKey.map(value => value),
        teamId.map(value => value)
      )
    def clientId: Option[__string]
    def keyId: Option[__string]
    def privateKey: Option[__string]
    def teamId: Option[__string]
    def getClientId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("clientId", clientId)
    def getKeyId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("keyId", keyId)
    def getPrivateKey: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("privateKey", privateKey)
    def getTeamId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("teamId", teamId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplifybackend.model.BackendAuthAppleProviderConfig
  ) extends zio.aws.amplifybackend.model.BackendAuthAppleProviderConfig.ReadOnly {
    override val clientId: Option[__string] = scala
      .Option(impl.clientId())
      .map(value => zio.aws.amplifybackend.model.primitives.__string(value))
    override val keyId: Option[__string] = scala
      .Option(impl.keyId())
      .map(value => zio.aws.amplifybackend.model.primitives.__string(value))
    override val privateKey: Option[__string] = scala
      .Option(impl.privateKey())
      .map(value => zio.aws.amplifybackend.model.primitives.__string(value))
    override val teamId: Option[__string] = scala
      .Option(impl.teamId())
      .map(value => zio.aws.amplifybackend.model.primitives.__string(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplifybackend.model.BackendAuthAppleProviderConfig
  ): zio.aws.amplifybackend.model.BackendAuthAppleProviderConfig.ReadOnly =
    new Wrapper(impl)
}
