package zio.aws.amplifybackend.model
import zio.aws.amplifybackend.model.primitives.__string
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CreateBackendApiResponse(
    appId: Option[__string] = None,
    backendEnvironmentName: Option[__string] = None,
    error: Option[__string] = None,
    jobId: Option[__string] = None,
    operation: Option[__string] = None,
    status: Option[__string] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.amplifybackend.model.CreateBackendApiResponse = {
    import CreateBackendApiResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplifybackend.model.CreateBackendApiResponse
      .builder()
      .optionallyWith(
        appId.map(value => __string.unwrap(value): java.lang.String)
      )(_.appId)
      .optionallyWith(
        backendEnvironmentName.map(value =>
          __string.unwrap(value): java.lang.String
        )
      )(_.backendEnvironmentName)
      .optionallyWith(
        error.map(value => __string.unwrap(value): java.lang.String)
      )(_.error)
      .optionallyWith(
        jobId.map(value => __string.unwrap(value): java.lang.String)
      )(_.jobId)
      .optionallyWith(
        operation.map(value => __string.unwrap(value): java.lang.String)
      )(_.operation)
      .optionallyWith(
        status.map(value => __string.unwrap(value): java.lang.String)
      )(_.status)
      .build()
  }
  def asReadOnly
      : zio.aws.amplifybackend.model.CreateBackendApiResponse.ReadOnly =
    zio.aws.amplifybackend.model.CreateBackendApiResponse.wrap(buildAwsValue())
}
object CreateBackendApiResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.amplifybackend.model.CreateBackendApiResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.amplifybackend.model.CreateBackendApiResponse =
      zio.aws.amplifybackend.model.CreateBackendApiResponse(
        appId.map(value => value),
        backendEnvironmentName.map(value => value),
        error.map(value => value),
        jobId.map(value => value),
        operation.map(value => value),
        status.map(value => value)
      )
    def appId: Option[__string]
    def backendEnvironmentName: Option[__string]
    def error: Option[__string]
    def jobId: Option[__string]
    def operation: Option[__string]
    def status: Option[__string]
    def getAppId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("appId", appId)
    def getBackendEnvironmentName: ZIO[Any, AwsError, __string] = AwsError
      .unwrapOptionField("backendEnvironmentName", backendEnvironmentName)
    def getError: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("error", error)
    def getJobId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("jobId", jobId)
    def getOperation: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("operation", operation)
    def getStatus: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplifybackend.model.CreateBackendApiResponse
  ) extends zio.aws.amplifybackend.model.CreateBackendApiResponse.ReadOnly {
    override val appId: Option[__string] = scala
      .Option(impl.appId())
      .map(value => zio.aws.amplifybackend.model.primitives.__string(value))
    override val backendEnvironmentName: Option[__string] = scala
      .Option(impl.backendEnvironmentName())
      .map(value => zio.aws.amplifybackend.model.primitives.__string(value))
    override val error: Option[__string] = scala
      .Option(impl.error())
      .map(value => zio.aws.amplifybackend.model.primitives.__string(value))
    override val jobId: Option[__string] = scala
      .Option(impl.jobId())
      .map(value => zio.aws.amplifybackend.model.primitives.__string(value))
    override val operation: Option[__string] = scala
      .Option(impl.operation())
      .map(value => zio.aws.amplifybackend.model.primitives.__string(value))
    override val status: Option[__string] = scala
      .Option(impl.status())
      .map(value => zio.aws.amplifybackend.model.primitives.__string(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplifybackend.model.CreateBackendApiResponse
  ): zio.aws.amplifybackend.model.CreateBackendApiResponse.ReadOnly =
    new Wrapper(impl)
}
