package zio.aws.amplifybackend.model
import zio.aws.amplifybackend.model.primitives.__string
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ImportBackendStorageRequest(
    appId: __string,
    backendEnvironmentName: __string,
    bucketName: Option[__string] = None,
    serviceName: zio.aws.amplifybackend.model.ServiceName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.amplifybackend.model.ImportBackendStorageRequest = {
    import ImportBackendStorageRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplifybackend.model.ImportBackendStorageRequest
      .builder()
      .appId(__string.unwrap(appId): java.lang.String)
      .backendEnvironmentName(
        __string.unwrap(backendEnvironmentName): java.lang.String
      )
      .optionallyWith(
        bucketName.map(value => __string.unwrap(value): java.lang.String)
      )(_.bucketName)
      .serviceName(serviceName.unwrap)
      .build()
  }
  def asReadOnly
      : zio.aws.amplifybackend.model.ImportBackendStorageRequest.ReadOnly =
    zio.aws.amplifybackend.model.ImportBackendStorageRequest
      .wrap(buildAwsValue())
}
object ImportBackendStorageRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.amplifybackend.model.ImportBackendStorageRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.amplifybackend.model.ImportBackendStorageRequest =
      zio.aws.amplifybackend.model.ImportBackendStorageRequest(
        appId,
        backendEnvironmentName,
        bucketName.map(value => value),
        serviceName
      )
    def appId: __string
    def backendEnvironmentName: __string
    def bucketName: Option[__string]
    def serviceName: zio.aws.amplifybackend.model.ServiceName
    def getAppId: ZIO[Any, Nothing, __string] = ZIO.succeed(appId)
    def getBackendEnvironmentName: ZIO[Any, Nothing, __string] =
      ZIO.succeed(backendEnvironmentName)
    def getBucketName: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("bucketName", bucketName)
    def getServiceName
        : ZIO[Any, Nothing, zio.aws.amplifybackend.model.ServiceName] =
      ZIO.succeed(serviceName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplifybackend.model.ImportBackendStorageRequest
  ) extends zio.aws.amplifybackend.model.ImportBackendStorageRequest.ReadOnly {
    override val appId: __string =
      zio.aws.amplifybackend.model.primitives.__string(impl.appId())
    override val backendEnvironmentName: __string =
      zio.aws.amplifybackend.model.primitives
        .__string(impl.backendEnvironmentName())
    override val bucketName: Option[__string] = scala
      .Option(impl.bucketName())
      .map(value => zio.aws.amplifybackend.model.primitives.__string(value))
    override val serviceName: zio.aws.amplifybackend.model.ServiceName =
      zio.aws.amplifybackend.model.ServiceName.wrap(impl.serviceName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplifybackend.model.ImportBackendStorageRequest
  ): zio.aws.amplifybackend.model.ImportBackendStorageRequest.ReadOnly =
    new Wrapper(impl)
}
