package zio.aws.amplifybackend.model
import zio.aws.amplifybackend.model.primitives.__string
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class GetBackendStorageRequest(
    appId: __string,
    backendEnvironmentName: __string,
    resourceName: __string
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.amplifybackend.model.GetBackendStorageRequest = {
    import GetBackendStorageRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplifybackend.model.GetBackendStorageRequest
      .builder()
      .appId(__string.unwrap(appId): java.lang.String)
      .backendEnvironmentName(
        __string.unwrap(backendEnvironmentName): java.lang.String
      )
      .resourceName(__string.unwrap(resourceName): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.amplifybackend.model.GetBackendStorageRequest.ReadOnly =
    zio.aws.amplifybackend.model.GetBackendStorageRequest.wrap(buildAwsValue())
}
object GetBackendStorageRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.amplifybackend.model.GetBackendStorageRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.amplifybackend.model.GetBackendStorageRequest =
      zio.aws.amplifybackend.model
        .GetBackendStorageRequest(appId, backendEnvironmentName, resourceName)
    def appId: __string
    def backendEnvironmentName: __string
    def resourceName: __string
    def getAppId: ZIO[Any, Nothing, __string] = ZIO.succeed(appId)
    def getBackendEnvironmentName: ZIO[Any, Nothing, __string] =
      ZIO.succeed(backendEnvironmentName)
    def getResourceName: ZIO[Any, Nothing, __string] = ZIO.succeed(resourceName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplifybackend.model.GetBackendStorageRequest
  ) extends zio.aws.amplifybackend.model.GetBackendStorageRequest.ReadOnly {
    override val appId: __string =
      zio.aws.amplifybackend.model.primitives.__string(impl.appId())
    override val backendEnvironmentName: __string =
      zio.aws.amplifybackend.model.primitives
        .__string(impl.backendEnvironmentName())
    override val resourceName: __string =
      zio.aws.amplifybackend.model.primitives.__string(impl.resourceName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplifybackend.model.GetBackendStorageRequest
  ): zio.aws.amplifybackend.model.GetBackendStorageRequest.ReadOnly =
    new Wrapper(impl)
}
