package zio.aws.amplifybackend.model
import zio.aws.amplifybackend.model.primitives.{__boolean, __string}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetBackendStorageResourceConfig(
    bucketName: Option[__string] = None,
    imported: __boolean,
    permissions: Option[
      zio.aws.amplifybackend.model.BackendStoragePermissions
    ] = None,
    serviceName: zio.aws.amplifybackend.model.ServiceName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.amplifybackend.model.GetBackendStorageResourceConfig = {
    import GetBackendStorageResourceConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplifybackend.model.GetBackendStorageResourceConfig
      .builder()
      .optionallyWith(
        bucketName.map(value => __string.unwrap(value): java.lang.String)
      )(_.bucketName)
      .imported(__boolean.unwrap(imported): java.lang.Boolean)
      .optionallyWith(permissions.map(value => value.buildAwsValue()))(
        _.permissions
      )
      .serviceName(serviceName.unwrap)
      .build()
  }
  def asReadOnly
      : zio.aws.amplifybackend.model.GetBackendStorageResourceConfig.ReadOnly =
    zio.aws.amplifybackend.model.GetBackendStorageResourceConfig
      .wrap(buildAwsValue())
}
object GetBackendStorageResourceConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.amplifybackend.model.GetBackendStorageResourceConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.amplifybackend.model.GetBackendStorageResourceConfig =
      zio.aws.amplifybackend.model.GetBackendStorageResourceConfig(
        bucketName.map(value => value),
        imported,
        permissions.map(value => value.asEditable),
        serviceName
      )
    def bucketName: Option[__string]
    def imported: __boolean
    def permissions: Option[
      zio.aws.amplifybackend.model.BackendStoragePermissions.ReadOnly
    ]
    def serviceName: zio.aws.amplifybackend.model.ServiceName
    def getBucketName: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("bucketName", bucketName)
    def getImported: ZIO[Any, Nothing, __boolean] = ZIO.succeed(imported)
    def getPermissions: ZIO[
      Any,
      AwsError,
      zio.aws.amplifybackend.model.BackendStoragePermissions.ReadOnly
    ] = AwsError.unwrapOptionField("permissions", permissions)
    def getServiceName
        : ZIO[Any, Nothing, zio.aws.amplifybackend.model.ServiceName] =
      ZIO.succeed(serviceName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplifybackend.model.GetBackendStorageResourceConfig
  ) extends zio.aws.amplifybackend.model.GetBackendStorageResourceConfig.ReadOnly {
    override val bucketName: Option[__string] = scala
      .Option(impl.bucketName())
      .map(value => zio.aws.amplifybackend.model.primitives.__string(value))
    override val imported: __boolean =
      zio.aws.amplifybackend.model.primitives.__boolean(impl.imported())
    override val permissions: Option[
      zio.aws.amplifybackend.model.BackendStoragePermissions.ReadOnly
    ] = scala
      .Option(impl.permissions())
      .map(value =>
        zio.aws.amplifybackend.model.BackendStoragePermissions.wrap(value)
      )
    override val serviceName: zio.aws.amplifybackend.model.ServiceName =
      zio.aws.amplifybackend.model.ServiceName.wrap(impl.serviceName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplifybackend.model.GetBackendStorageResourceConfig
  ): zio.aws.amplifybackend.model.GetBackendStorageResourceConfig.ReadOnly =
    new Wrapper(impl)
}
