package zio.aws.amplifybackend.model
import scala.jdk.CollectionConverters.*
sealed trait DeliveryMethod {
  def unwrap
      : software.amazon.awssdk.services.amplifybackend.model.DeliveryMethod
}
object DeliveryMethod {
  def wrap(
      value: software.amazon.awssdk.services.amplifybackend.model.DeliveryMethod
  ): zio.aws.amplifybackend.model.DeliveryMethod = value match {
    case software.amazon.awssdk.services.amplifybackend.model.DeliveryMethod.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.amplifybackend.model.DeliveryMethod.EMAIL =>
      val r = EMAIL
      r
    case software.amazon.awssdk.services.amplifybackend.model.DeliveryMethod.SMS =>
      val r = SMS
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.amplifybackend.model.DeliveryMethod {
    override def unwrap
        : software.amazon.awssdk.services.amplifybackend.model.DeliveryMethod =
      software.amazon.awssdk.services.amplifybackend.model.DeliveryMethod.UNKNOWN_TO_SDK_VERSION
  }
  case object EMAIL extends zio.aws.amplifybackend.model.DeliveryMethod {
    override def unwrap
        : software.amazon.awssdk.services.amplifybackend.model.DeliveryMethod =
      software.amazon.awssdk.services.amplifybackend.model.DeliveryMethod.EMAIL
  }
  case object SMS extends zio.aws.amplifybackend.model.DeliveryMethod {
    override def unwrap
        : software.amazon.awssdk.services.amplifybackend.model.DeliveryMethod =
      software.amazon.awssdk.services.amplifybackend.model.DeliveryMethod.SMS
  }
}
