package zio.aws.amplifybackend.model
import zio.aws.amplifybackend.model.primitives.__string
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetBackendApiModelsResponse(
    models: Optional[__string] = Optional.Absent,
    status: Optional[zio.aws.amplifybackend.model.Status] = Optional.Absent,
    modelIntrospectionSchema: Optional[__string] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.amplifybackend.model.GetBackendApiModelsResponse = {
    import GetBackendApiModelsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplifybackend.model.GetBackendApiModelsResponse
      .builder()
      .optionallyWith(models.map(value => value: java.lang.String))(_.models)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        modelIntrospectionSchema.map(value => value: java.lang.String)
      )(_.modelIntrospectionSchema)
      .build()
  }
  def asReadOnly
      : zio.aws.amplifybackend.model.GetBackendApiModelsResponse.ReadOnly =
    zio.aws.amplifybackend.model.GetBackendApiModelsResponse
      .wrap(buildAwsValue())
}
object GetBackendApiModelsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.amplifybackend.model.GetBackendApiModelsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.amplifybackend.model.GetBackendApiModelsResponse =
      zio.aws.amplifybackend.model.GetBackendApiModelsResponse(
        models.map(value => value),
        status.map(value => value),
        modelIntrospectionSchema.map(value => value)
      )
    def models: Optional[__string]
    def status: Optional[zio.aws.amplifybackend.model.Status]
    def modelIntrospectionSchema: Optional[__string]
    def getModels: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("models", models)
    def getStatus: ZIO[Any, AwsError, zio.aws.amplifybackend.model.Status] =
      AwsError.unwrapOptionField("status", status)
    def getModelIntrospectionSchema: ZIO[Any, AwsError, __string] = AwsError
      .unwrapOptionField("modelIntrospectionSchema", modelIntrospectionSchema)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplifybackend.model.GetBackendApiModelsResponse
  ) extends zio.aws.amplifybackend.model.GetBackendApiModelsResponse.ReadOnly {
    override val models: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.models())
      .map(value => value: __string)
    override val status: Optional[zio.aws.amplifybackend.model.Status] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.amplifybackend.model.Status.wrap(value))
    override val modelIntrospectionSchema: Optional[__string] =
      zio.aws.core.internal
        .optionalFromNullable(impl.modelIntrospectionSchema())
        .map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplifybackend.model.GetBackendApiModelsResponse
  ): zio.aws.amplifybackend.model.GetBackendApiModelsResponse.ReadOnly =
    new Wrapper(impl)
}
