package zio.aws.amplifybackend.model
import zio.aws.amplifybackend.model.primitives.__string
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateBackendAuthUserPoolConfig(
    forgotPassword: Optional[
      zio.aws.amplifybackend.model.CreateBackendAuthForgotPasswordConfig
    ] = Optional.Absent,
    mfa: Optional[zio.aws.amplifybackend.model.CreateBackendAuthMFAConfig] =
      Optional.Absent,
    oAuth: Optional[zio.aws.amplifybackend.model.CreateBackendAuthOAuthConfig] =
      Optional.Absent,
    passwordPolicy: Optional[
      zio.aws.amplifybackend.model.CreateBackendAuthPasswordPolicyConfig
    ] = Optional.Absent,
    requiredSignUpAttributes: Iterable[
      zio.aws.amplifybackend.model.RequiredSignUpAttributesElement
    ],
    signInMethod: zio.aws.amplifybackend.model.SignInMethod,
    userPoolName: __string,
    verificationMessage: Optional[
      zio.aws.amplifybackend.model.CreateBackendAuthVerificationMessageConfig
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.amplifybackend.model.CreateBackendAuthUserPoolConfig = {
    import CreateBackendAuthUserPoolConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplifybackend.model.CreateBackendAuthUserPoolConfig
      .builder()
      .optionallyWith(forgotPassword.map(value => value.buildAwsValue()))(
        _.forgotPassword
      )
      .optionallyWith(mfa.map(value => value.buildAwsValue()))(_.mfa)
      .optionallyWith(oAuth.map(value => value.buildAwsValue()))(_.oAuth)
      .optionallyWith(passwordPolicy.map(value => value.buildAwsValue()))(
        _.passwordPolicy
      )
      .requiredSignUpAttributesWithStrings(requiredSignUpAttributes.map {
        item =>
          item.unwrap.toString
      }.asJavaCollection)
      .signInMethod(signInMethod.unwrap)
      .userPoolName(userPoolName: java.lang.String)
      .optionallyWith(verificationMessage.map(value => value.buildAwsValue()))(
        _.verificationMessage
      )
      .build()
  }
  def asReadOnly
      : zio.aws.amplifybackend.model.CreateBackendAuthUserPoolConfig.ReadOnly =
    zio.aws.amplifybackend.model.CreateBackendAuthUserPoolConfig
      .wrap(buildAwsValue())
}
object CreateBackendAuthUserPoolConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.amplifybackend.model.CreateBackendAuthUserPoolConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.amplifybackend.model.CreateBackendAuthUserPoolConfig =
      zio.aws.amplifybackend.model.CreateBackendAuthUserPoolConfig(
        forgotPassword.map(value => value.asEditable),
        mfa.map(value => value.asEditable),
        oAuth.map(value => value.asEditable),
        passwordPolicy.map(value => value.asEditable),
        requiredSignUpAttributes,
        signInMethod,
        userPoolName,
        verificationMessage.map(value => value.asEditable)
      )
    def forgotPassword: Optional[
      zio.aws.amplifybackend.model.CreateBackendAuthForgotPasswordConfig.ReadOnly
    ]
    def mfa: Optional[
      zio.aws.amplifybackend.model.CreateBackendAuthMFAConfig.ReadOnly
    ]
    def oAuth: Optional[
      zio.aws.amplifybackend.model.CreateBackendAuthOAuthConfig.ReadOnly
    ]
    def passwordPolicy: Optional[
      zio.aws.amplifybackend.model.CreateBackendAuthPasswordPolicyConfig.ReadOnly
    ]
    def requiredSignUpAttributes
        : List[zio.aws.amplifybackend.model.RequiredSignUpAttributesElement]
    def signInMethod: zio.aws.amplifybackend.model.SignInMethod
    def userPoolName: __string
    def verificationMessage: Optional[
      zio.aws.amplifybackend.model.CreateBackendAuthVerificationMessageConfig.ReadOnly
    ]
    def getForgotPassword: ZIO[
      Any,
      AwsError,
      zio.aws.amplifybackend.model.CreateBackendAuthForgotPasswordConfig.ReadOnly
    ] = AwsError.unwrapOptionField("forgotPassword", forgotPassword)
    def getMfa: ZIO[
      Any,
      AwsError,
      zio.aws.amplifybackend.model.CreateBackendAuthMFAConfig.ReadOnly
    ] = AwsError.unwrapOptionField("mfa", mfa)
    def getOAuth: ZIO[
      Any,
      AwsError,
      zio.aws.amplifybackend.model.CreateBackendAuthOAuthConfig.ReadOnly
    ] = AwsError.unwrapOptionField("oAuth", oAuth)
    def getPasswordPolicy: ZIO[
      Any,
      AwsError,
      zio.aws.amplifybackend.model.CreateBackendAuthPasswordPolicyConfig.ReadOnly
    ] = AwsError.unwrapOptionField("passwordPolicy", passwordPolicy)
    def getRequiredSignUpAttributes: ZIO[Any, Nothing, List[
      zio.aws.amplifybackend.model.RequiredSignUpAttributesElement
    ]] = ZIO.succeed(requiredSignUpAttributes)
    def getSignInMethod
        : ZIO[Any, Nothing, zio.aws.amplifybackend.model.SignInMethod] =
      ZIO.succeed(signInMethod)
    def getUserPoolName: ZIO[Any, Nothing, __string] = ZIO.succeed(userPoolName)
    def getVerificationMessage: ZIO[
      Any,
      AwsError,
      zio.aws.amplifybackend.model.CreateBackendAuthVerificationMessageConfig.ReadOnly
    ] = AwsError.unwrapOptionField("verificationMessage", verificationMessage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplifybackend.model.CreateBackendAuthUserPoolConfig
  ) extends zio.aws.amplifybackend.model.CreateBackendAuthUserPoolConfig.ReadOnly {
    override val forgotPassword: Optional[
      zio.aws.amplifybackend.model.CreateBackendAuthForgotPasswordConfig.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.forgotPassword())
      .map(value =>
        zio.aws.amplifybackend.model.CreateBackendAuthForgotPasswordConfig
          .wrap(value)
      )
    override val mfa: Optional[
      zio.aws.amplifybackend.model.CreateBackendAuthMFAConfig.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.mfa())
      .map(value =>
        zio.aws.amplifybackend.model.CreateBackendAuthMFAConfig.wrap(value)
      )
    override val oAuth: Optional[
      zio.aws.amplifybackend.model.CreateBackendAuthOAuthConfig.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.oAuth())
      .map(value =>
        zio.aws.amplifybackend.model.CreateBackendAuthOAuthConfig.wrap(value)
      )
    override val passwordPolicy: Optional[
      zio.aws.amplifybackend.model.CreateBackendAuthPasswordPolicyConfig.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.passwordPolicy())
      .map(value =>
        zio.aws.amplifybackend.model.CreateBackendAuthPasswordPolicyConfig
          .wrap(value)
      )
    override val requiredSignUpAttributes
        : List[zio.aws.amplifybackend.model.RequiredSignUpAttributesElement] =
      impl
        .requiredSignUpAttributes()
        .asScala
        .map { item =>
          zio.aws.amplifybackend.model.RequiredSignUpAttributesElement
            .wrap(item)
        }
        .toList
    override val signInMethod: zio.aws.amplifybackend.model.SignInMethod =
      zio.aws.amplifybackend.model.SignInMethod.wrap(impl.signInMethod())
    override val userPoolName: __string = impl.userPoolName(): __string
    override val verificationMessage: Optional[
      zio.aws.amplifybackend.model.CreateBackendAuthVerificationMessageConfig.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.verificationMessage())
      .map(value =>
        zio.aws.amplifybackend.model.CreateBackendAuthVerificationMessageConfig
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplifybackend.model.CreateBackendAuthUserPoolConfig
  ): zio.aws.amplifybackend.model.CreateBackendAuthUserPoolConfig.ReadOnly =
    new Wrapper(impl)
}
