package zio.aws.amplifybackend.model
import zio.aws.amplifybackend.model.primitives.{__double, __string}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class BackendAPIAppSyncAuthSettings(
    cognitoUserPoolId: Optional[__string] = Optional.Absent,
    description: Optional[__string] = Optional.Absent,
    expirationTime: Optional[__double] = Optional.Absent,
    openIDAuthTTL: Optional[__string] = Optional.Absent,
    openIDClientId: Optional[__string] = Optional.Absent,
    openIDIatTTL: Optional[__string] = Optional.Absent,
    openIDIssueURL: Optional[__string] = Optional.Absent,
    openIDProviderName: Optional[__string] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.amplifybackend.model.BackendAPIAppSyncAuthSettings = {
    import BackendAPIAppSyncAuthSettings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplifybackend.model.BackendAPIAppSyncAuthSettings
      .builder()
      .optionallyWith(cognitoUserPoolId.map(value => value: java.lang.String))(
        _.cognitoUserPoolId
      )
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(expirationTime.map(value => value: java.lang.Double))(
        _.expirationTime
      )
      .optionallyWith(openIDAuthTTL.map(value => value: java.lang.String))(
        _.openIDAuthTTL
      )
      .optionallyWith(openIDClientId.map(value => value: java.lang.String))(
        _.openIDClientId
      )
      .optionallyWith(openIDIatTTL.map(value => value: java.lang.String))(
        _.openIDIatTTL
      )
      .optionallyWith(openIDIssueURL.map(value => value: java.lang.String))(
        _.openIDIssueURL
      )
      .optionallyWith(openIDProviderName.map(value => value: java.lang.String))(
        _.openIDProviderName
      )
      .build()
  }
  def asReadOnly
      : zio.aws.amplifybackend.model.BackendAPIAppSyncAuthSettings.ReadOnly =
    zio.aws.amplifybackend.model.BackendAPIAppSyncAuthSettings
      .wrap(buildAwsValue())
}
object BackendAPIAppSyncAuthSettings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.amplifybackend.model.BackendAPIAppSyncAuthSettings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.amplifybackend.model.BackendAPIAppSyncAuthSettings =
      zio.aws.amplifybackend.model.BackendAPIAppSyncAuthSettings(
        cognitoUserPoolId.map(value => value),
        description.map(value => value),
        expirationTime.map(value => value),
        openIDAuthTTL.map(value => value),
        openIDClientId.map(value => value),
        openIDIatTTL.map(value => value),
        openIDIssueURL.map(value => value),
        openIDProviderName.map(value => value)
      )
    def cognitoUserPoolId: Optional[__string]
    def description: Optional[__string]
    def expirationTime: Optional[__double]
    def openIDAuthTTL: Optional[__string]
    def openIDClientId: Optional[__string]
    def openIDIatTTL: Optional[__string]
    def openIDIssueURL: Optional[__string]
    def openIDProviderName: Optional[__string]
    def getCognitoUserPoolId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("cognitoUserPoolId", cognitoUserPoolId)
    def getDescription: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("description", description)
    def getExpirationTime: ZIO[Any, AwsError, __double] =
      AwsError.unwrapOptionField("expirationTime", expirationTime)
    def getOpenIDAuthTTL: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("openIDAuthTTL", openIDAuthTTL)
    def getOpenIDClientId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("openIDClientId", openIDClientId)
    def getOpenIDIatTTL: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("openIDIatTTL", openIDIatTTL)
    def getOpenIDIssueURL: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("openIDIssueURL", openIDIssueURL)
    def getOpenIDProviderName: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("openIDProviderName", openIDProviderName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplifybackend.model.BackendAPIAppSyncAuthSettings
  ) extends zio.aws.amplifybackend.model.BackendAPIAppSyncAuthSettings.ReadOnly {
    override val cognitoUserPoolId: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.cognitoUserPoolId())
      .map(value => value: __string)
    override val description: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => value: __string)
    override val expirationTime: Optional[__double] = zio.aws.core.internal
      .optionalFromNullable(impl.expirationTime())
      .map(value => value: __double)
    override val openIDAuthTTL: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.openIDAuthTTL())
      .map(value => value: __string)
    override val openIDClientId: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.openIDClientId())
      .map(value => value: __string)
    override val openIDIatTTL: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.openIDIatTTL())
      .map(value => value: __string)
    override val openIDIssueURL: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.openIDIssueURL())
      .map(value => value: __string)
    override val openIDProviderName: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.openIDProviderName())
      .map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplifybackend.model.BackendAPIAppSyncAuthSettings
  ): zio.aws.amplifybackend.model.BackendAPIAppSyncAuthSettings.ReadOnly =
    new Wrapper(impl)
}
