package zio.aws.amplifybackend.model
import zio.aws.amplifybackend.model.primitives.__string
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateBackendApiRequest(
    appId: __string,
    backendEnvironmentName: __string,
    resourceConfig: Optional[
      zio.aws.amplifybackend.model.BackendAPIResourceConfig
    ] = Optional.Absent,
    resourceName: __string
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.amplifybackend.model.UpdateBackendApiRequest = {
    import UpdateBackendApiRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplifybackend.model.UpdateBackendApiRequest
      .builder()
      .appId(appId: java.lang.String)
      .backendEnvironmentName(backendEnvironmentName: java.lang.String)
      .optionallyWith(resourceConfig.map(value => value.buildAwsValue()))(
        _.resourceConfig
      )
      .resourceName(resourceName: java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.amplifybackend.model.UpdateBackendApiRequest.ReadOnly =
    zio.aws.amplifybackend.model.UpdateBackendApiRequest.wrap(buildAwsValue())
}
object UpdateBackendApiRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.amplifybackend.model.UpdateBackendApiRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.amplifybackend.model.UpdateBackendApiRequest =
      zio.aws.amplifybackend.model.UpdateBackendApiRequest(
        appId,
        backendEnvironmentName,
        resourceConfig.map(value => value.asEditable),
        resourceName
      )
    def appId: __string
    def backendEnvironmentName: __string
    def resourceConfig: Optional[
      zio.aws.amplifybackend.model.BackendAPIResourceConfig.ReadOnly
    ]
    def resourceName: __string
    def getAppId: ZIO[Any, Nothing, __string] = ZIO.succeed(appId)
    def getBackendEnvironmentName: ZIO[Any, Nothing, __string] =
      ZIO.succeed(backendEnvironmentName)
    def getResourceConfig: ZIO[
      Any,
      AwsError,
      zio.aws.amplifybackend.model.BackendAPIResourceConfig.ReadOnly
    ] = AwsError.unwrapOptionField("resourceConfig", resourceConfig)
    def getResourceName: ZIO[Any, Nothing, __string] = ZIO.succeed(resourceName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplifybackend.model.UpdateBackendApiRequest
  ) extends zio.aws.amplifybackend.model.UpdateBackendApiRequest.ReadOnly {
    override val appId: __string = impl.appId(): __string
    override val backendEnvironmentName: __string =
      impl.backendEnvironmentName(): __string
    override val resourceConfig: Optional[
      zio.aws.amplifybackend.model.BackendAPIResourceConfig.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.resourceConfig())
      .map(value =>
        zio.aws.amplifybackend.model.BackendAPIResourceConfig.wrap(value)
      )
    override val resourceName: __string = impl.resourceName(): __string
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplifybackend.model.UpdateBackendApiRequest
  ): zio.aws.amplifybackend.model.UpdateBackendApiRequest.ReadOnly =
    new Wrapper(impl)
}
