package zio.aws.amplifybackend.model
import scala.jdk.CollectionConverters._
sealed trait SignInMethod {
  def unwrap: software.amazon.awssdk.services.amplifybackend.model.SignInMethod
}
object SignInMethod {
  def wrap(
      value: software.amazon.awssdk.services.amplifybackend.model.SignInMethod
  ): zio.aws.amplifybackend.model.SignInMethod = value match {
    case software.amazon.awssdk.services.amplifybackend.model.SignInMethod.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.amplifybackend.model.SignInMethod.EMAIL =>
      val r = EMAIL
      r
    case software.amazon.awssdk.services.amplifybackend.model.SignInMethod.EMAIL_AND_PHONE_NUMBER =>
      val r = EMAIL_AND_PHONE_NUMBER
      r
    case software.amazon.awssdk.services.amplifybackend.model.SignInMethod.PHONE_NUMBER =>
      val r = PHONE_NUMBER
      r
    case software.amazon.awssdk.services.amplifybackend.model.SignInMethod.USERNAME =>
      val r = USERNAME
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.amplifybackend.model.SignInMethod {
    override def unwrap
        : software.amazon.awssdk.services.amplifybackend.model.SignInMethod =
      software.amazon.awssdk.services.amplifybackend.model.SignInMethod.UNKNOWN_TO_SDK_VERSION
  }
  case object EMAIL extends zio.aws.amplifybackend.model.SignInMethod {
    override def unwrap
        : software.amazon.awssdk.services.amplifybackend.model.SignInMethod =
      software.amazon.awssdk.services.amplifybackend.model.SignInMethod.EMAIL
  }
  case object EMAIL_AND_PHONE_NUMBER
      extends zio.aws.amplifybackend.model.SignInMethod {
    override def unwrap
        : software.amazon.awssdk.services.amplifybackend.model.SignInMethod =
      software.amazon.awssdk.services.amplifybackend.model.SignInMethod.EMAIL_AND_PHONE_NUMBER
  }
  case object PHONE_NUMBER extends zio.aws.amplifybackend.model.SignInMethod {
    override def unwrap
        : software.amazon.awssdk.services.amplifybackend.model.SignInMethod =
      software.amazon.awssdk.services.amplifybackend.model.SignInMethod.PHONE_NUMBER
  }
  case object USERNAME extends zio.aws.amplifybackend.model.SignInMethod {
    override def unwrap
        : software.amazon.awssdk.services.amplifybackend.model.SignInMethod =
      software.amazon.awssdk.services.amplifybackend.model.SignInMethod.USERNAME
  }
}
