package zio.aws.amplifybackend.model
import zio.aws.amplifybackend.model.primitives.__string
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class Settings(
    mfaTypes: Optional[Iterable[zio.aws.amplifybackend.model.MfaTypesElement]] =
      Optional.Absent,
    smsMessage: Optional[__string] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.amplifybackend.model.Settings = {
    import Settings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplifybackend.model.Settings
      .builder()
      .optionallyWith(
        mfaTypes.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.mfaTypesWithStrings)
      .optionallyWith(smsMessage.map(value => value: java.lang.String))(
        _.smsMessage
      )
      .build()
  }
  def asReadOnly: zio.aws.amplifybackend.model.Settings.ReadOnly =
    zio.aws.amplifybackend.model.Settings.wrap(buildAwsValue())
}
object Settings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.amplifybackend.model.Settings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.amplifybackend.model.Settings =
      zio.aws.amplifybackend.model
        .Settings(mfaTypes.map(value => value), smsMessage.map(value => value))
    def mfaTypes: Optional[List[zio.aws.amplifybackend.model.MfaTypesElement]]
    def smsMessage: Optional[__string]
    def getMfaTypes: ZIO[Any, AwsError, List[
      zio.aws.amplifybackend.model.MfaTypesElement
    ]] = AwsError.unwrapOptionField("mfaTypes", mfaTypes)
    def getSmsMessage: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("smsMessage", smsMessage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplifybackend.model.Settings
  ) extends zio.aws.amplifybackend.model.Settings.ReadOnly {
    override val mfaTypes
        : Optional[List[zio.aws.amplifybackend.model.MfaTypesElement]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.mfaTypes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.amplifybackend.model.MfaTypesElement.wrap(item)
          }.toList
        )
    override val smsMessage: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.smsMessage())
      .map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplifybackend.model.Settings
  ): zio.aws.amplifybackend.model.Settings.ReadOnly = new Wrapper(impl)
}
