package zio.aws.amplifybackend.model
import zio.aws.amplifybackend.model.primitives.__string
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListBackendJobsResponse(
    jobs: Optional[Iterable[zio.aws.amplifybackend.model.BackendJobRespObj]] =
      Optional.Absent,
    nextToken: Optional[__string] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.amplifybackend.model.ListBackendJobsResponse = {
    import ListBackendJobsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplifybackend.model.ListBackendJobsResponse
      .builder()
      .optionallyWith(
        jobs.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.jobs)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.amplifybackend.model.ListBackendJobsResponse.ReadOnly =
    zio.aws.amplifybackend.model.ListBackendJobsResponse.wrap(buildAwsValue())
}
object ListBackendJobsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.amplifybackend.model.ListBackendJobsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.amplifybackend.model.ListBackendJobsResponse =
      zio.aws.amplifybackend.model.ListBackendJobsResponse(
        jobs.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def jobs: Optional[
      List[zio.aws.amplifybackend.model.BackendJobRespObj.ReadOnly]
    ]
    def nextToken: Optional[__string]
    def getJobs: ZIO[Any, AwsError, List[
      zio.aws.amplifybackend.model.BackendJobRespObj.ReadOnly
    ]] = AwsError.unwrapOptionField("jobs", jobs)
    def getNextToken: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplifybackend.model.ListBackendJobsResponse
  ) extends zio.aws.amplifybackend.model.ListBackendJobsResponse.ReadOnly {
    override val jobs: Optional[
      List[zio.aws.amplifybackend.model.BackendJobRespObj.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.jobs())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.amplifybackend.model.BackendJobRespObj.wrap(item)
        }.toList
      )
    override val nextToken: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplifybackend.model.ListBackendJobsResponse
  ): zio.aws.amplifybackend.model.ListBackendJobsResponse.ReadOnly =
    new Wrapper(impl)
}
