package zio.aws.amplifybackend.model
import zio.aws.amplifybackend.model.primitives.{__boolean, __string}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class RemoveAllBackendsRequest(
    appId: __string,
    cleanAmplifyApp: Optional[__boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.amplifybackend.model.RemoveAllBackendsRequest = {
    import RemoveAllBackendsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplifybackend.model.RemoveAllBackendsRequest
      .builder()
      .appId(appId: java.lang.String)
      .optionallyWith(cleanAmplifyApp.map(value => value: java.lang.Boolean))(
        _.cleanAmplifyApp
      )
      .build()
  }
  def asReadOnly
      : zio.aws.amplifybackend.model.RemoveAllBackendsRequest.ReadOnly =
    zio.aws.amplifybackend.model.RemoveAllBackendsRequest.wrap(buildAwsValue())
}
object RemoveAllBackendsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.amplifybackend.model.RemoveAllBackendsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.amplifybackend.model.RemoveAllBackendsRequest =
      zio.aws.amplifybackend.model
        .RemoveAllBackendsRequest(appId, cleanAmplifyApp.map(value => value))
    def appId: __string
    def cleanAmplifyApp: Optional[__boolean]
    def getAppId: ZIO[Any, Nothing, __string] = ZIO.succeed(appId)
    def getCleanAmplifyApp: ZIO[Any, AwsError, __boolean] =
      AwsError.unwrapOptionField("cleanAmplifyApp", cleanAmplifyApp)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplifybackend.model.RemoveAllBackendsRequest
  ) extends zio.aws.amplifybackend.model.RemoveAllBackendsRequest.ReadOnly {
    override val appId: __string = impl.appId(): __string
    override val cleanAmplifyApp: Optional[__boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.cleanAmplifyApp())
      .map(value => value: __boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplifybackend.model.RemoveAllBackendsRequest
  ): zio.aws.amplifybackend.model.RemoveAllBackendsRequest.ReadOnly =
    new Wrapper(impl)
}
