package zio.aws.amplifybackend.model
import zio.aws.amplifybackend.model.primitives.__string
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateBackendConfigRequest(
    appId: __string,
    backendManagerAppId: Optional[__string] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.amplifybackend.model.CreateBackendConfigRequest = {
    import CreateBackendConfigRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplifybackend.model.CreateBackendConfigRequest
      .builder()
      .appId(appId: java.lang.String)
      .optionallyWith(
        backendManagerAppId.map(value => value: java.lang.String)
      )(_.backendManagerAppId)
      .build()
  }
  def asReadOnly
      : zio.aws.amplifybackend.model.CreateBackendConfigRequest.ReadOnly =
    zio.aws.amplifybackend.model.CreateBackendConfigRequest
      .wrap(buildAwsValue())
}
object CreateBackendConfigRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.amplifybackend.model.CreateBackendConfigRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.amplifybackend.model.CreateBackendConfigRequest =
      zio.aws.amplifybackend.model.CreateBackendConfigRequest(
        appId,
        backendManagerAppId.map(value => value)
      )
    def appId: __string
    def backendManagerAppId: Optional[__string]
    def getAppId: ZIO[Any, Nothing, __string] = ZIO.succeed(appId)
    def getBackendManagerAppId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("backendManagerAppId", backendManagerAppId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplifybackend.model.CreateBackendConfigRequest
  ) extends zio.aws.amplifybackend.model.CreateBackendConfigRequest.ReadOnly {
    override val appId: __string = impl.appId(): __string
    override val backendManagerAppId: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.backendManagerAppId())
      .map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplifybackend.model.CreateBackendConfigRequest
  ): zio.aws.amplifybackend.model.CreateBackendConfigRequest.ReadOnly =
    new Wrapper(impl)
}
