package zio.aws.amplifybackend.model
import zio.aws.amplifybackend.model.primitives.__string
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class BackendAuthAppleProviderConfig(
    clientId: Optional[__string] = Optional.Absent,
    keyId: Optional[__string] = Optional.Absent,
    privateKey: Optional[__string] = Optional.Absent,
    teamId: Optional[__string] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.amplifybackend.model.BackendAuthAppleProviderConfig = {
    import BackendAuthAppleProviderConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplifybackend.model.BackendAuthAppleProviderConfig
      .builder()
      .optionallyWith(clientId.map(value => value: java.lang.String))(
        _.clientId
      )
      .optionallyWith(keyId.map(value => value: java.lang.String))(_.keyId)
      .optionallyWith(privateKey.map(value => value: java.lang.String))(
        _.privateKey
      )
      .optionallyWith(teamId.map(value => value: java.lang.String))(_.teamId)
      .build()
  }
  def asReadOnly
      : zio.aws.amplifybackend.model.BackendAuthAppleProviderConfig.ReadOnly =
    zio.aws.amplifybackend.model.BackendAuthAppleProviderConfig
      .wrap(buildAwsValue())
}
object BackendAuthAppleProviderConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.amplifybackend.model.BackendAuthAppleProviderConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.amplifybackend.model.BackendAuthAppleProviderConfig =
      zio.aws.amplifybackend.model.BackendAuthAppleProviderConfig(
        clientId.map(value => value),
        keyId.map(value => value),
        privateKey.map(value => value),
        teamId.map(value => value)
      )
    def clientId: Optional[__string]
    def keyId: Optional[__string]
    def privateKey: Optional[__string]
    def teamId: Optional[__string]
    def getClientId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("clientId", clientId)
    def getKeyId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("keyId", keyId)
    def getPrivateKey: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("privateKey", privateKey)
    def getTeamId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("teamId", teamId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplifybackend.model.BackendAuthAppleProviderConfig
  ) extends zio.aws.amplifybackend.model.BackendAuthAppleProviderConfig.ReadOnly {
    override val clientId: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.clientId())
      .map(value => value: __string)
    override val keyId: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.keyId())
      .map(value => value: __string)
    override val privateKey: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.privateKey())
      .map(value => value: __string)
    override val teamId: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.teamId())
      .map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplifybackend.model.BackendAuthAppleProviderConfig
  ): zio.aws.amplifybackend.model.BackendAuthAppleProviderConfig.ReadOnly =
    new Wrapper(impl)
}
