package zio.aws.amplifybackend.model
import scala.jdk.CollectionConverters._
sealed trait AuthenticatedElement {
  def unwrap: software.amazon.awssdk.services.amplifybackend.model.AuthenticatedElement
}
object AuthenticatedElement {
  def wrap(
      value: software.amazon.awssdk.services.amplifybackend.model.AuthenticatedElement
  ): zio.aws.amplifybackend.model.AuthenticatedElement = value match {
    case software.amazon.awssdk.services.amplifybackend.model.AuthenticatedElement.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.amplifybackend.model.AuthenticatedElement.READ =>
      val r = READ
      r
    case software.amazon.awssdk.services.amplifybackend.model.AuthenticatedElement.CREATE_AND_UPDATE =>
      val r = CREATE_AND_UPDATE
      r
    case software.amazon.awssdk.services.amplifybackend.model.AuthenticatedElement.DELETE =>
      val r = DELETE
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.amplifybackend.model.AuthenticatedElement {
    override def unwrap
        : software.amazon.awssdk.services.amplifybackend.model.AuthenticatedElement =
      software.amazon.awssdk.services.amplifybackend.model.AuthenticatedElement.UNKNOWN_TO_SDK_VERSION
  }
  case object READ extends zio.aws.amplifybackend.model.AuthenticatedElement {
    override def unwrap
        : software.amazon.awssdk.services.amplifybackend.model.AuthenticatedElement =
      software.amazon.awssdk.services.amplifybackend.model.AuthenticatedElement.READ
  }
  case object CREATE_AND_UPDATE
      extends zio.aws.amplifybackend.model.AuthenticatedElement {
    override def unwrap
        : software.amazon.awssdk.services.amplifybackend.model.AuthenticatedElement =
      software.amazon.awssdk.services.amplifybackend.model.AuthenticatedElement.CREATE_AND_UPDATE
  }
  case object DELETE extends zio.aws.amplifybackend.model.AuthenticatedElement {
    override def unwrap
        : software.amazon.awssdk.services.amplifybackend.model.AuthenticatedElement =
      software.amazon.awssdk.services.amplifybackend.model.AuthenticatedElement.DELETE
  }
}
