package zio.aws.amplifybackend.model
import scala.jdk.CollectionConverters._
sealed trait Mode {
  def unwrap: software.amazon.awssdk.services.amplifybackend.model.Mode
}
object Mode {
  def wrap(
      value: software.amazon.awssdk.services.amplifybackend.model.Mode
  ): zio.aws.amplifybackend.model.Mode = value match {
    case software.amazon.awssdk.services.amplifybackend.model.Mode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.amplifybackend.model.Mode.API_KEY =>
      val r = API_KEY
      r
    case software.amazon.awssdk.services.amplifybackend.model.Mode.AWS_IAM =>
      val r = AWS_IAM
      r
    case software.amazon.awssdk.services.amplifybackend.model.Mode.AMAZON_COGNITO_USER_POOLS =>
      val r = AMAZON_COGNITO_USER_POOLS
      r
    case software.amazon.awssdk.services.amplifybackend.model.Mode.OPENID_CONNECT =>
      val r = OPENID_CONNECT
      r
  }
  case object unknownToSdkVersion extends zio.aws.amplifybackend.model.Mode {
    override def unwrap
        : software.amazon.awssdk.services.amplifybackend.model.Mode =
      software.amazon.awssdk.services.amplifybackend.model.Mode.UNKNOWN_TO_SDK_VERSION
  }
  case object API_KEY extends zio.aws.amplifybackend.model.Mode {
    override def unwrap
        : software.amazon.awssdk.services.amplifybackend.model.Mode =
      software.amazon.awssdk.services.amplifybackend.model.Mode.API_KEY
  }
  case object AWS_IAM extends zio.aws.amplifybackend.model.Mode {
    override def unwrap
        : software.amazon.awssdk.services.amplifybackend.model.Mode =
      software.amazon.awssdk.services.amplifybackend.model.Mode.AWS_IAM
  }
  case object AMAZON_COGNITO_USER_POOLS
      extends zio.aws.amplifybackend.model.Mode {
    override def unwrap
        : software.amazon.awssdk.services.amplifybackend.model.Mode =
      software.amazon.awssdk.services.amplifybackend.model.Mode.AMAZON_COGNITO_USER_POOLS
  }
  case object OPENID_CONNECT extends zio.aws.amplifybackend.model.Mode {
    override def unwrap
        : software.amazon.awssdk.services.amplifybackend.model.Mode =
      software.amazon.awssdk.services.amplifybackend.model.Mode.OPENID_CONNECT
  }
}
