package zio.aws.amplifybackend.model
import zio.aws.amplifybackend.model.primitives.__string
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetTokenResponse(
    appId: Optional[__string] = Optional.Absent,
    challengeCode: Optional[__string] = Optional.Absent,
    sessionId: Optional[__string] = Optional.Absent,
    ttl: Optional[__string] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.amplifybackend.model.GetTokenResponse = {
    import GetTokenResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplifybackend.model.GetTokenResponse
      .builder()
      .optionallyWith(appId.map(value => value: java.lang.String))(_.appId)
      .optionallyWith(challengeCode.map(value => value: java.lang.String))(
        _.challengeCode
      )
      .optionallyWith(sessionId.map(value => value: java.lang.String))(
        _.sessionId
      )
      .optionallyWith(ttl.map(value => value: java.lang.String))(_.ttl)
      .build()
  }
  def asReadOnly: zio.aws.amplifybackend.model.GetTokenResponse.ReadOnly =
    zio.aws.amplifybackend.model.GetTokenResponse.wrap(buildAwsValue())
}
object GetTokenResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.amplifybackend.model.GetTokenResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.amplifybackend.model.GetTokenResponse =
      zio.aws.amplifybackend.model.GetTokenResponse(
        appId.map(value => value),
        challengeCode.map(value => value),
        sessionId.map(value => value),
        ttl.map(value => value)
      )
    def appId: Optional[__string]
    def challengeCode: Optional[__string]
    def sessionId: Optional[__string]
    def ttl: Optional[__string]
    def getAppId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("appId", appId)
    def getChallengeCode: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("challengeCode", challengeCode)
    def getSessionId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("sessionId", sessionId)
    def getTtl: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("ttl", ttl)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplifybackend.model.GetTokenResponse
  ) extends zio.aws.amplifybackend.model.GetTokenResponse.ReadOnly {
    override val appId: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.appId())
      .map(value => value: __string)
    override val challengeCode: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.challengeCode())
      .map(value => value: __string)
    override val sessionId: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.sessionId())
      .map(value => value: __string)
    override val ttl: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.ttl())
      .map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplifybackend.model.GetTokenResponse
  ): zio.aws.amplifybackend.model.GetTokenResponse.ReadOnly = new Wrapper(impl)
}
