package zio.aws.amplifybackend.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class BackendAPIAuthType(
    mode: Optional[zio.aws.amplifybackend.model.Mode] = Optional.Absent,
    settings: Optional[
      zio.aws.amplifybackend.model.BackendAPIAppSyncAuthSettings
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.amplifybackend.model.BackendAPIAuthType = {
    import BackendAPIAuthType.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplifybackend.model.BackendAPIAuthType
      .builder()
      .optionallyWith(mode.map(value => value.unwrap))(_.mode)
      .optionallyWith(settings.map(value => value.buildAwsValue()))(_.settings)
      .build()
  }
  def asReadOnly: zio.aws.amplifybackend.model.BackendAPIAuthType.ReadOnly =
    zio.aws.amplifybackend.model.BackendAPIAuthType.wrap(buildAwsValue())
}
object BackendAPIAuthType {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.amplifybackend.model.BackendAPIAuthType
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.amplifybackend.model.BackendAPIAuthType =
      zio.aws.amplifybackend.model.BackendAPIAuthType(
        mode.map(value => value),
        settings.map(value => value.asEditable)
      )
    def mode: Optional[zio.aws.amplifybackend.model.Mode]
    def settings: Optional[
      zio.aws.amplifybackend.model.BackendAPIAppSyncAuthSettings.ReadOnly
    ]
    def getMode: ZIO[Any, AwsError, zio.aws.amplifybackend.model.Mode] =
      AwsError.unwrapOptionField("mode", mode)
    def getSettings: ZIO[
      Any,
      AwsError,
      zio.aws.amplifybackend.model.BackendAPIAppSyncAuthSettings.ReadOnly
    ] = AwsError.unwrapOptionField("settings", settings)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplifybackend.model.BackendAPIAuthType
  ) extends zio.aws.amplifybackend.model.BackendAPIAuthType.ReadOnly {
    override val mode: Optional[zio.aws.amplifybackend.model.Mode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.mode())
        .map(value => zio.aws.amplifybackend.model.Mode.wrap(value))
    override val settings: Optional[
      zio.aws.amplifybackend.model.BackendAPIAppSyncAuthSettings.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.settings())
      .map(value =>
        zio.aws.amplifybackend.model.BackendAPIAppSyncAuthSettings.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplifybackend.model.BackendAPIAuthType
  ): zio.aws.amplifybackend.model.BackendAPIAuthType.ReadOnly = new Wrapper(
    impl
  )
}
